/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.gconsole.util.swing;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.text.ParseException;
import java.util.regex.Pattern;
import javax.swing.BoxLayout;
import javax.swing.JFormattedTextField;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DocumentFilter;

/**
 * {@link JTextField} that limits its maximum height to its preferred height.
 * Intended for use with {@link BoxLayout}.
 *
 * @author onoprien
 */
public class BoxedFormattedTextField extends JFormattedTextField {

// -- Life cycle : -------------------------------------------------------------

    public BoxedFormattedTextField() {
        super();
    }

    public BoxedFormattedTextField(Object value) {
        super(value);
    }

    public BoxedFormattedTextField(java.text.Format format) {
        super(format);
    }

    public BoxedFormattedTextField(AbstractFormatter formatter) {
        super(formatter);
    }

    public BoxedFormattedTextField(AbstractFormatterFactory factory) {
        super(factory);
    }

    public BoxedFormattedTextField(AbstractFormatterFactory factory, Object currentValue) {
        super(factory, currentValue);
    }
  

// -- Limit max size : ---------------------------------------------------------

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(super.getMaximumSize().width, super.getPreferredSize().height);
    }
    
    
// -- Formatter that restricts set of valid characters : -----------------------
    
    public final void setFilter(String regex) {
        ((AbstractDocument) getDocument()).setDocumentFilter(new Filter(regex));
    }
    
    static public class CharFilter extends DefaultFormatter {
        
        private final Pattern pattern;
        
        public CharFilter(String regex) {
            pattern = Pattern.compile(regex);
        }

        @Override
        public Object stringToValue(String text) throws ParseException {
            return text;
        }

        @Override
        public String valueToString(Object value) throws ParseException {
            return value == null ? null : value.toString();
        }

        @Override
        protected DocumentFilter getDocumentFilter() {
            return new DocumentFilter() {
                @Override
                public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                    if (text == null || pattern.matcher(text).matches()) {
                        super.replace(fb, offset, length, text, attrs);
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
                @Override
                public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
                    if (string == null || pattern.matcher(string).matches()) {
                        super.insertString(fb, offset, string, attr);
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
            };
        }
    }
    
    static public class Filter extends DocumentFilter {

        private final Pattern pattern;

        public Filter(String regex) {
            pattern = Pattern.compile(regex);
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (text == null || pattern.matcher(text).matches()) {
                super.replace(fb, offset, length, text, attrs);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            if (string == null || pattern.matcher(string).matches()) {
                super.insertString(fb, offset, string, attr);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
    
}
