package org.lsst.ccs.gconsole.services.aggregator;

import java.util.*;
import org.lsst.ccs.Agent;

/**
 * Dictionary of data channels published by an {@link Agent}.
 * Constructed and maintained by {@link AgentStatusAggregator}.
 *
 * @author onoprien
 */
class AgentChannelsDictionary {

// -- Fields : -----------------------------------------------------------------
    
    private final ArrayList<AgentChannel> channels;
    private Map<String, String> key2path;


// -- Life cycle : -------------------------------------------------------------
    
    AgentChannelsDictionary(List<AgentChannel> channels) {
        this.channels = new ArrayList<>(channels);
        HashMap<String, String> map = new HashMap<>();
        channels.forEach(c -> {
            String key = (String) c.get(AgentChannel.Key.TRENDING);
            if (key != null) {
                String path = c.getLocalPath();
                if (!path.equals(key)) {
                    map.put(key, path);
                }
            }
        });
        key2path = map.isEmpty() ? Collections.emptyMap() : map;
    }

// -- Getters : ----------------------------------------------------------------
    
    List<AgentChannel> getAllChannels() {
        return Collections.unmodifiableList(channels);
    }
        
    AgentChannel getChannelByPath(String innerPath) {
        for (AgentChannel chan : channels) {
            if (chan.getLocalPath().equals(innerPath)) {
                return chan;
            }
        }
        return null;
    }
    
    String getPathFromTrendingKey(String key) {
        return key2path.getOrDefault(key, key);
    }
    
    
// -- Adding channels : --------------------------------------------------------
    
    void add(AgentChannel channel) {
        String key = (String) channel.get(AgentChannel.Key.TRENDING);
        if (key != null) {
            String path = channel.getLocalPath();
            if (!path.equals(key)) {
                if (key2path.isEmpty()) key2path = new HashMap<>();
                key2path.put(key, path);
            }
        }
        channels.ensureCapacity(channels.size()+1);
        channels.add(channel);
    }

}
