package org.lsst.ccs.gconsole.base.filter;

import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;


/**
 *
 * @author onoprien
 */
public class TestFilter extends AbstractChannelsFilter {
    
    private final Logger LOG = Logger.getLogger("TestFilter");
    
//    @Create(category = AgentChannelsFilter.CATEGORY,
//            name = "Test",
//            path = "Built-In/Tests/T1",
//            description = "")
    static public PersistableAgentChannelsFilter getTest() {
        return new TestFilter();
    }

    @Override
    public String getName() {
        return "Test";
    }

    @Override
    public List<String> getAgents() {
        return super.getAgents();
    }

    @Override
    public List<String> getOriginChannels() {
        System.out.println("getOriginChannels()");
        return Collections.singletonList("/.+/CommandState");
    }

    @Override
    public List<String> getDisplayChannels() {
        return super.getDisplayChannels();
    }

    @Override
    public List<String> getFields(boolean compact) {
        return super.getFields(compact);
    }

    @Override
    public List<String> getGroups() {
        return super.getGroups();
    }

    @Override
    public List<String> getDisplayPaths(AgentChannel channel) {
        return super.getDisplayPaths(channel);
    }

    @Override
    public List<String> getDisplayPaths(String originPath) {
        return super.getDisplayPaths(originPath);
    }

    @Override
    public String getDisplayPath(AgentChannel channel) {
        return super.getDisplayPath(channel);
    }

    @Override
    public String getDisplayPath(String originPath) {
        System.out.print(".");
        return originPath.contains("state") ? originPath : null;
    }

    @Override
    public List<String> getOriginPaths(String displayPath) {
        return super.getOriginPaths(displayPath);
    }

    @Override
    public String getOriginPath(String displayPath) {
        return super.getOriginPath(displayPath);
    }


}
