/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.ccs;

import java.util.logging.Level;

public class CCSProperty {
    private final String value;

    public CCSProperty(String name) {
        String s = System.getProperty(name);
        this.value = s == null || s.isBlank() ? null : s.trim();
    }

    public CCSProperty(String name, String value) {
        this.value = value.trim();
    }

    public static Level getMaxLevel(CCSProperty ... properties) {
        Level out = null;
        for (CCSProperty p : properties) {
            Level level = p.getLevel();
            if (level == null || out != null && out.intValue() >= level.intValue()) continue;
            out = level;
        }
        return out;
    }

    public boolean isSet() {
        return this.value != null;
    }

    public String get(String key) {
        if (this.value == null) {
            return null;
        }
        for (String s : this.value.split("&")) {
            String[] ss;
            if (s.isBlank() || (ss = s.split("=")).length != 2 || !ss[0].trim().equals(key)) continue;
            return ss[1].trim();
        }
        return null;
    }

    public double getDouble(String key) {
        String s = this.get(key);
        if (s == null) {
            return Double.NaN;
        }
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException x) {
            return Double.NaN;
        }
    }

    public double getDouble() {
        if (this.value == null) {
            return Double.NaN;
        }
        for (String s : this.value.split("&")) {
            if (s.isBlank() || s.contains("=")) continue;
            try {
                return Double.parseDouble(s.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Double.NaN;
    }

    public int getInt(String key) {
        String s = this.get(key);
        if (s == null) {
            return Integer.MIN_VALUE;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException x) {
            return Integer.MIN_VALUE;
        }
    }

    public int getInt() {
        if (this.value == null) {
            return Integer.MIN_VALUE;
        }
        for (String s : this.value.split("&")) {
            if (s.isBlank() || s.contains("=")) continue;
            try {
                return Integer.parseInt(s.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Integer.MIN_VALUE;
    }

    public boolean getBoolean(String key) {
        if (this.value == null) {
            return false;
        }
        for (String s : this.value.split("&")) {
            String[] ss;
            if (s.isBlank() || !(ss = s.split("="))[0].trim().equals(key)) continue;
            if (ss.length == 1) {
                return true;
            }
            if (ss.length != 2) continue;
            return !"false".equalsIgnoreCase(ss[1]);
        }
        return false;
    }

    public Level getLevel() {
        if (this.value == null) {
            return null;
        }
        for (String s : this.value.split("&")) {
            String name;
            if (s.isBlank()) continue;
            String[] ss = s.split("=");
            switch (ss.length) {
                case 1: {
                    String string = ss[0].trim();
                    break;
                }
                case 2: {
                    String string;
                    if ("level".equals(ss[0].trim())) {
                        string = ss[1].trim();
                        break;
                    }
                    string = null;
                    break;
                }
                default: {
                    String string = name = null;
                }
            }
            if (name == null || !name.matches("\\D+")) continue;
            try {
                return Level.parse(name);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return Level.INFO;
    }

    public static void main(String ... s) {
        CCSProperty p = new CCSProperty("", "441");
        System.out.println(p.getBoolean("FINE"));
        System.out.println(p.getLevel());
        System.out.println(p.getDouble());
        System.out.println(p.getDouble("x"));
        System.out.println(p.getInt());
        p = new CCSProperty("", "x=4&FINE & 441");
        System.out.println(p.getBoolean("FINE"));
        System.out.println(p.getLevel());
        System.out.println(p.getDouble());
        System.out.println(p.getDouble("x"));
        System.out.println(p.getInt());
    }
}

