/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.lsst.ccs.gconsole.agent.AgentChannelsFilter;
import org.lsst.ccs.gconsole.annotations.ConsoleLookup;
import org.lsst.ccs.gconsole.base.InstanceDialog;
import org.lsst.ccs.gconsole.plugins.monitor.AbstractMonitorView1;
import org.lsst.ccs.gconsole.plugins.monitor.DefaultView;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorView;

class MonitorPageDialog
extends JDialog {
    private final String defaultName = "Monitor";
    private boolean nameNotEdited = true;
    private MonitorView view;
    private AgentChannelsFilter filter;
    private InstanceDialog viewDialog;
    private InstanceDialog filterDialog;
    private Descriptor descriptor;
    private JTextField nameField;
    private JTextField viewField;
    private JTextField filterField;

    private MonitorPageDialog(Component parentComponent) {
        super(parentComponent == null ? null : SwingUtilities.getWindowAncestor(parentComponent), "Open new monitoring page", Dialog.ModalityType.APPLICATION_MODAL);
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(3, 8, 3, 8);
        c.anchor = 13;
        c.gridx = 0;
        c.gridy = 0;
        JLabel label = new JLabel("Page name:");
        gridbag.setConstraints(label, c);
        this.add(label);
        c.gridy = 1;
        label = new JLabel("View type:");
        gridbag.setConstraints(label, c);
        this.add(label);
        c.gridy = 2;
        label = new JLabel("Filter:");
        gridbag.setConstraints(label, c);
        this.add(label);
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 1;
        c.gridy = 0;
        this.nameField = new JTextField("Monitor", 50);
        this.nameField.addCaretListener(e -> {
            if (this.nameNotEdited) {
                this.nameNotEdited = false;
            }
        });
        gridbag.setConstraints(this.nameField, c);
        this.add(this.nameField);
        c.gridy = 1;
        this.viewField = new JTextField("Default view", 50);
        this.viewField.setEditable(false);
        gridbag.setConstraints(this.viewField, c);
        this.add(this.viewField);
        c.gridy = 2;
        this.filterField = new JTextField("Unfiltered", 50);
        this.filterField.setEditable(false);
        gridbag.setConstraints(this.filterField, c);
        this.add(this.filterField);
        c.fill = 0;
        c.weightx = 0.0;
        c.gridx = 2;
        c.gridy = 1;
        JButton button = new JButton("...");
        button.setToolTipText("Select view type");
        button.addActionListener(e -> {
            this.viewDialog = InstanceDialog.show(MonitorView.class, (Component)this, "Select view type", MonitorView.class.getName());
            MonitorView v = (MonitorView)this.viewDialog.getInstance();
            if (v != null) {
                this.view = v;
                String name = this.view.getName();
                if (name == null || name.trim().isEmpty()) {
                    Class<?> viewClass = this.view.getClass();
                    ConsoleLookup cl = viewClass.getAnnotation(ConsoleLookup.class);
                    if (cl != null) {
                        name = cl.name();
                    }
                    if (name == null || name.isEmpty()) {
                        name = viewClass.getSimpleName();
                    }
                } else if (this.nameNotEdited && this.nameField.getText().equals("Monitor")) {
                    this.nameField.setText(name);
                }
                this.viewField.setText(name);
            }
        });
        gridbag.setConstraints(button, c);
        this.add(button);
        c.gridy = 2;
        button = new JButton("...");
        button.setToolTipText("Select filter");
        button.addActionListener(e -> {
            this.filterDialog = InstanceDialog.show(AgentChannelsFilter.class, (Component)this, "Select filter", AgentChannelsFilter.class.getName());
            AgentChannelsFilter f = (AgentChannelsFilter)this.filterDialog.getInstance();
            if (f != null) {
                this.filter = f;
                String name = this.filter.getName();
                if (name == null || name.isEmpty()) {
                    Class<?> filterClass = this.filter.getClass();
                    ConsoleLookup cl = filterClass.getAnnotation(ConsoleLookup.class);
                    if (cl != null) {
                        name = cl.name();
                    }
                    if (name == null || name.isEmpty()) {
                        name = filterClass.getSimpleName();
                    }
                } else if (this.nameNotEdited) {
                    this.nameField.setText(name);
                }
                this.filterField.setText(name);
            }
        });
        gridbag.setConstraints(button, c);
        this.add(button);
        c.gridx = 0;
        c.gridy = 3;
        c.anchor = 14;
        c.gridwidth = 0;
        c.weighty = 1.0;
        c.insets = new Insets(16, 8, 4, 8);
        JPanel box = new JPanel();
        box.setLayout(new GridLayout(1, 2, 16, 5));
        button = new JButton("Cancel");
        button.addActionListener(e -> {
            this.view = null;
            this.filter = null;
            this.viewDialog = null;
            this.filterDialog = null;
            this.dispose();
        });
        box.add(button);
        button = new JButton("OK");
        button.addActionListener(e -> {
            this.done();
            this.dispose();
        });
        box.add(button);
        gridbag.setConstraints(box, c);
        this.add(box);
    }

    static MonitorPageDialog show(Component parentComponent) {
        MonitorPageDialog dialog = new MonitorPageDialog(parentComponent);
        dialog.setSize(dialog.getPreferredSize());
        dialog.pack();
        dialog.setLocationRelativeTo(parentComponent);
        dialog.setVisible(true);
        return dialog;
    }

    static MonitorView getView(Descriptor descriptor) {
        DefaultView view;
        MonitorView monitorView = view = descriptor.viewDescriptor == null ? new DefaultView() : InstanceDialog.getInstance(descriptor.viewDescriptor, MonitorView.class, (String)null);
        if (view == null) {
            return null;
        }
        if (descriptor.name != null) {
            view.setName(descriptor.name);
        }
        if (descriptor.filterDescriptor != null) {
            AgentChannelsFilter filter = InstanceDialog.getInstance(descriptor.filterDescriptor, AgentChannelsFilter.class, (String)null);
            if (filter == null) {
                return null;
            }
            view.setFilter(filter);
        } else {
            view.setFilter(AgentChannelsFilter.ALL);
        }
        return view;
    }

    static MonitorView getView(MonitorView.Descriptor descriptor) {
        Serializable desc = descriptor.getCreator();
        if (desc instanceof Descriptor) {
            MonitorView view = MonitorPageDialog.getView((Descriptor)desc);
            if (view == null) {
                return null;
            }
            view.restore(descriptor);
            return view;
        }
        return null;
    }

    MonitorView getView() {
        return this.view;
    }

    Descriptor getDescriptor() {
        return this.descriptor;
    }

    private void done() {
        this.descriptor = new Descriptor();
        if (this.view == null) {
            this.view = new DefaultView();
        } else {
            this.descriptor.setViewDescriptor(this.viewDialog.getDescriptor());
        }
        String viewName = this.nameField.getText();
        this.view.setName(viewName);
        this.descriptor.setName(viewName);
        if (this.filter == null) {
            this.filter = AgentChannelsFilter.ALL;
        } else {
            this.descriptor.setFilterDescriptor(this.filterDialog.getDescriptor());
        }
        this.view.setFilter(this.filter);
        MonitorView.Descriptor viewDesc = this.view.save();
        if (viewDesc == null) {
            viewDesc = new AbstractMonitorView1.Descriptor();
        }
        viewDesc.setCreator(this.descriptor);
        viewDesc.setName(viewName);
        this.view.restore(viewDesc);
    }

    public static class Descriptor
    implements Serializable {
        private String name;
        private InstanceDialog.Descriptor viewDescriptor;
        private InstanceDialog.Descriptor filterDescriptor;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public InstanceDialog.Descriptor getViewDescriptor() {
            return this.viewDescriptor;
        }

        public void setViewDescriptor(InstanceDialog.Descriptor viewDescriptor) {
            this.viewDescriptor = viewDescriptor;
        }

        public InstanceDialog.Descriptor getFilterDescriptor() {
            return this.filterDescriptor;
        }

        public void setFilterDescriptor(InstanceDialog.Descriptor filterDescriptor) {
            this.filterDescriptor = filterDescriptor;
        }
    }
}

