package org.lsst.ccs.gconsole.util.refrig;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.plugins.monitor.CellTableView;
import org.lsst.ccs.gconsole.plugins.monitor.DefaultChannelHandle;
import org.lsst.ccs.gconsole.plugins.monitor.FormattedValue;
import org.lsst.ccs.gconsole.plugins.monitor.ImageView;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorCell;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;

class FrontPage  {

// -- Fields : -----------------------------------------------------------------
    
    private final RefrigerationPlugin plugin;
    private final AgentInfo agent;
    
    private ImageView view;

// -- Life cycle : -------------------------------------------------------------
    
    FrontPage(RefrigerationPlugin plugin, AgentInfo agent) {
        this.plugin = plugin;
        this.agent = agent;
    }
    
    public ImageView getView() {
        
        if (view != null) return view;
        
        try {
            
            BufferedImage back = ImageIO.read(ImageView.class.getResource("/org/lsst/ccs/gconsole/util/refrig/main.png"));
            view = new ImageView("Refrigeration", back, .5, 2.);
            
            // Compressors:
            
            placeCompressor(0.2948, 0.0972, 
                    "/main/DemoDevice1/DemoChannel0", 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1", 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel2", 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel3"
            );
            
            placeCompressor(0.4225, 0.0972, 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel4", 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel5", 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel6", 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel7"
            );
            
            placeCompressor(0.5505, 0.0972, 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel8", 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel9", 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel10", 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel11"
            );
            
            placeCompressor(0.6906, 0.0972, 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel12", 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel13", 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel14", 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel15"
            );
            
            placeCompressor(0.2948, 0.2597, 
                    "/main/DemoDevice1/DemoChannel0", 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1", 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel2", 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel3"
            );
            
            placeCompressor(0.4225, 0.2597, 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel4", 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel5", 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel6", 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel7"
            );
            
            placeCompressor(0.5505, 0.2597, 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel8", 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel9", 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel10", 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel11"
            );
            
            placeCompressor(0.6906, 0.2597, 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel12", 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel13", 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel14", 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel15"
            );
            
            // Heat exch:
            
            placeHeatExch(0.2938, 0.4083, 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel10", 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel11"
            );
            
            placeHeatExch(0.4325, 0.4083, 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel10", 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel11"
            );
            
            placeHeatExch(0.5510, 0.4083, 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel10", 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel11"
            );
            
            placeHeatExch(0.6890, 0.4083, 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel10", 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel11"
            );
            
            placeHeatExch(0.2938, 0.4889, 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel10", 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel11"
            );
            
            placeHeatExch(0.4325, 0.4889, 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel10", 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel11"
            );
            
            placeHeatExch(0.5510, 0.4889, 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel10", 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel11"
            );
            
            placeHeatExch(0.6890, 0.4889, 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel10", 
                    "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel11"
            );
            
            // Cold:

            ImageView.Item item;
            CellTableView table;

            DefaultChannelHandle handle = new DefaultChannelHandle("demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel0", null, null);
            FormattedValue fv = new FormattedValue();
            fv.horizontalAlignment = SwingUtilities.CENTER;
            MonitorField field = new MonitorField(MonitorField.VALUE.getKey(), null, fv, MonitorField.VALUE.getKeys());
            MonitorCell c0 = new MonitorCell(handle, field);

            table = new CellTableView(1, 1, c0);
            item = new ImageView.Item(table);
            item.setPosition(0.6130, 0.7194);
            item.setAlignment(JComponent.CENTER_ALIGNMENT, JComponent.CENTER_ALIGNMENT);
//            item.setSize(0.06, 0.07);
            item.setMaxSize(0.1188, 0.0472);
            view.add(item);
            
            // Cryo:

            handle = new DefaultChannelHandle("demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel0", null, null);
            fv = new FormattedValue();
            fv.horizontalAlignment = SwingUtilities.CENTER;
            field = new MonitorField(MonitorField.VALUE.getKey(), null, fv, MonitorField.VALUE.getKeys());
            c0 = new MonitorCell(handle, field);

            table = new CellTableView(1, 1, c0);
            item = new ImageView.Item(table);
            item.setPosition(0.3720, 0.7847);
            item.setAlignment(JComponent.CENTER_ALIGNMENT, JComponent.CENTER_ALIGNMENT);
            item.setMaxSize(0.1188, 0.0472);
            view.add(item);
            
            // Link to vacuum:
            
            MouseListener vacuumListener = new MouseAdapter() {
                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 1) {
                        plugin.setVacuumOpen(agent, true);
                    }
                }
            };
            
            // Vac4:

            handle = new DefaultChannelHandle("demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel0", null, null);
            fv = new FormattedValue();
            fv.horizontalAlignment = SwingUtilities.CENTER;
            field = new MonitorField(MonitorField.VALUE.getKey(), null, fv, MonitorField.VALUE.getKeys());
            c0 = new MonitorCell(handle, field);

            table = new CellTableView(1, 1, c0);
            table.addMouseListener(vacuumListener);
            item = new ImageView.Item(table);
            item.setPosition(0.7500, 0.5806);
            item.setAlignment(JComponent.LEFT_ALIGNMENT, JComponent.CENTER_ALIGNMENT);
            item.setMaxSize(0.1188, 0.0472);
            view.add(item);
            
            // Vac3:

            handle = new DefaultChannelHandle("demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel0", null, null);
            fv = new FormattedValue();
            fv.horizontalAlignment = SwingUtilities.CENTER;
            field = new MonitorField(MonitorField.VALUE.getKey(), null, fv, MonitorField.VALUE.getKeys());
            c0 = new MonitorCell(handle, field);

            table = new CellTableView(1, 1, c0);
            table.addMouseListener(vacuumListener);
            item = new ImageView.Item(table);
            item.setPosition(0.7417, 0.8097);
            item.setAlignment(JComponent.LEFT_ALIGNMENT, JComponent.CENTER_ALIGNMENT);
            item.setMaxSize(0.1188, 0.0472);
            view.add(item);
            

        } catch (IOException e) {
        }
        
        return view;
    }
    
    private void placeCompressor(double x, double y, String ch0, String ch1, String ch2, String ch3) throws IOException {

        ImageView.Item item;
        CellTableView table;

        DefaultChannelHandle handle = new DefaultChannelHandle(ch0, null, null);
        FormattedValue fv = new FormattedValue();
        fv.horizontalAlignment = SwingUtilities.CENTER;
        MonitorField field = new MonitorField(MonitorField.VALUE.getKey(), null, fv, MonitorField.VALUE.getKeys());
        MonitorCell c0 = new MonitorCell(handle, field);

        handle = new DefaultChannelHandle(ch1, null, null);
        fv = new FormattedValue();
        fv.horizontalAlignment = SwingUtilities.CENTER;
        field = new MonitorField(MonitorField.VALUE.getKey(), null, fv, MonitorField.VALUE.getKeys());
        MonitorCell c1 = new MonitorCell(handle, field);

        handle = new DefaultChannelHandle(ch2, null, null);
        fv = new FormattedValue();
        fv.horizontalAlignment = SwingUtilities.CENTER;
        field = new MonitorField(MonitorField.VALUE.getKey(), null, fv, MonitorField.VALUE.getKeys());
        MonitorCell c2 = new MonitorCell(handle, field);

        handle = new DefaultChannelHandle(ch3, null, null);
        fv = new FormattedValue();
        fv.horizontalAlignment = SwingUtilities.CENTER;
        field = new MonitorField(MonitorField.VALUE.getKey(), null, fv, MonitorField.VALUE.getKeys());
        MonitorCell c3 = new MonitorCell(handle, field);
        table = new CellTableView(2, 2, c0, c1, c2, c3);
        table.setEqualRows(true);
        table.setEqualColumns(true);
        item = new ImageView.Item(table);
        item.setPosition(x, y);
        item.setAlignment(JComponent.CENTER_ALIGNMENT, JComponent.CENTER_ALIGNMENT);
        item.setSize(0.0813, 0.1084);
        item.setMaxSize(0.10, 0.13);
        view.add(item);

        BufferedImage cir = ImageIO.read(ImageView.class.getResource("/org/lsst/ccs/gconsole/plugins/demo/monitor/image/circle.png"));
        item = new ImageView.Item(cir);
        item.setPosition(x, y);
        item.setAlignment(JComponent.CENTER_ALIGNMENT, JComponent.CENTER_ALIGNMENT);
        item.setSize(25, 25);
        item.setLayer(3);
        view.add(item);

    }
    
    private void placeHeatExch(double x, double y, String ch0, String ch1) throws IOException {

        ImageView.Item item;
        CellTableView table;

        DefaultChannelHandle handle = new DefaultChannelHandle(ch0, null, null);
        FormattedValue fv = new FormattedValue();
        fv.horizontalAlignment = SwingUtilities.CENTER;
        MonitorField field = new MonitorField(MonitorField.VALUE.getKey(), null, fv, MonitorField.VALUE.getKeys());
        MonitorCell c0 = new MonitorCell(handle, field);

        handle = new DefaultChannelHandle(ch1, null, null);
        fv = new FormattedValue();
        fv.horizontalAlignment = SwingUtilities.CENTER;
        field = new MonitorField(MonitorField.VALUE.getKey(), null, fv, MonitorField.VALUE.getKeys());
        MonitorCell c1 = new MonitorCell(handle, field);
        
        table = new CellTableView(2, 1, c0, c1);
        table.setEqualRows(true);
        table.setEqualColumns(true);
        item = new ImageView.Item(table);
        item.setPosition(x, y);
        item.setAlignment(JComponent.CENTER_ALIGNMENT, JComponent.CENTER_ALIGNMENT);
        item.setSize(0.06, 0.07);
        item.setMaxSize(0.07, 0.081);
        view.add(item);
    }
    
}
