package org.lsst.ccs.gconsole.plugins.trending;

/**
 * Filter that modifies the way trending channels are displayed in the tree, and generates derived channels.
 *
 * @author onoprien
 */
public interface TrendingFilter {
    
    /**
     * Creates a filtered trending source.
     * The source returned by this method should be wired to receive events from
     * the original source if necessary.
     * 
     * @param source The original unfiltered source.
     * @return The filtered source.
     */
    TrendingSource filter(TrendingSource source);
    
}
