package org.lsst.ccs.gconsole.plugins.tracer;

/**
 * Factory that creates {@link MessageFilter} instances.
 * Filters created by the same factory instance with the same parameters are expected to have identical
 * functionality and be able to operate concurrently without interfering with one another.
 * <p>
 * To be usable with {@code InstanceDialog}, the factory should also define {@code getInstance(...)} method.
 *
 * @author onoprien
 */
public interface MessageFilterFactory {
    
    /**
     * Returns the path of the filters created by this factory.
     * @return Path.
     */
    String getPath();
    
    /**
     * Returns the path of the filters created by this factory.
     * @return Name.
     */
    default String getName() {
        String path = getPath();
        return path.substring(path.lastIndexOf("/")+1);
    }
    
    /**
     * Returns the description of the filters created by this factory.
     * @return Filter description.
     */
    default String getDescription() {
        return "";
    }
    
    /**
     * Constructs and returns a filter.
     * @param parameters Parameters.
     * @return Filter created by this factory.
     */
    MessageFilter get(String[] parameters);
   
}
