package org.lsst.ccs.gconsole.plugins.tracer;

/**
 * Interface to be implemented by tracer filters.
 * Applying this filter to a message may modify the message, in addition to accepting or
 * rejecting it.
 * <p>
 * This interface extends MessageFilterFactory and provides a default implementation for
 * its get(...) method. The method is implemented to return the filter itself. This allows 
 * registering instances of this class with the graphical console lookup to be picked up by
 * the {@link FilterRegistry}. Note that this approach is only safe if the filter's test(...)
 * method can be invoked concurrently by multiple threads on multiple messages.
 * Default implementations provided for {@code getParameters()} and {@code setParameters(...)}
 * methods are suitable for filters that have no parameters. Parameterized filters might
 * use {@link AbstractMessageFilter} as a base class to simplify implementation.
 *
 * @author onoprien
 */
public interface MessageFilter extends MessageFilterFactory {
    
    /**
     * Applies this filter to the given message.
     * 
     * @param filteredMessage The message to be filtered.
     * @return The (possibly modified) message if it passes the filter; {@code null} otherwise.
     */
    FilteredMessage test(FilteredMessage filteredMessage);
    
    /** Returns a reference to this filter. */
    @Override
    default MessageFilter get(String[] parameters) {
        return this;
    }

    @Override
    default String getPath() {
        return "";
    }
    
    default String[] getParameters() {
        return new String[0];
    }
    
    default void setParameters(String[] parameters) {
    }

}
