package org.lsst.ccs.gconsole.plugins.monitor;

import java.util.*;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.lsst.ccs.gconsole.agent.AgentChannelsFilter;
import org.lsst.ccs.subsystem.monitor.ui.tree.MonitorDisplay;

/**
 * {@link MonitorView} that displays data channels in a single table with the name column rendered as a tree.
 * <p>
 * <font color=red>
 * The implementation relies on a hacky {@code JXTreeTable}, and has been found to be unreliable.
 * For now, it has been excluded from the standard set of views. If we ever decide we need it, it
 * (and the underlying {@code TreeTable}) will have to reviewed and updated.
 * </font>
 *
 * @author onoprien
 */
//@ConsoleLookup(id="org.lsst.ccs.gconsole.plugins.monitor.MonitorView",
//               name="Tree Table View",
//               path="Built-In/Tree Table",
//               description="Monitoring view that displays its data in a table with collapsible rows.")
public class TreeTableView extends AbstractMonitorView2 {

// -- Fields : -----------------------------------------------------------------
    
    private final JScrollPane scrollPane = new JScrollPane();

// -- Life cycle : -------------------------------------------------------------
    
    public TreeTableView() {
        scrollPane.add(new MonitorDisplay.EMPTY());
    }

// -- Getters and setters : ----------------------------------------------------
    
    @Override
    public JComponent getPanel() {
        return scrollPane;
    }

// -- Updates from status aggregator : -----------------------------------------
    
    @Override
    protected void resetChannels() {
        AgentChannelsFilter filter = getFilter();
        List<String> attributes = filter == null ? null : filter.getFields(false);
        List<MonitorField> fields = attributes == null ? MonitorTable.DEFAULT_FIELDS : new ArrayList<>(MonitorField.getDefaultFields(attributes));
        TreeTable table = new TreeTable(path2data, fields);
        scrollPane.setViewportView(table.getTable());
        scrollPane.revalidate();
    }


}
