package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

/**
 * Renderer for monitoring data table cells.
 * Expects an instance of {@link FormattedValue} as the value of the cell.
 *
 * @author onoprien
 */
public class MonitorTableCellRenderer extends DefaultTableCellRenderer {

// -- Fields : -----------------------------------------------------------------
    
    private boolean ensureWidth = false;
    private boolean ensureHeight = false;

// -- Life cycle : -------------------------------------------------------------
    
// -- Setters : ----------------------------------------------------------------
    
    /**
     * Sets the flag that determines whether the table column width should increase if necessary to accommodate new values.
     * The default value is {@code false}.
     * 
     * @param ensureWidth If {@code true}, the table column width will increase if necessary to accommodate new values.
     */
    public void setEnsureWidth(boolean ensureWidth) {
        this.ensureWidth = ensureWidth;
    }

    /**
     * Sets the flag that determines whether the table row height should increase if necessary to accommodate new values.
     * The default value is {@code false}.
     * 
     * @param ensureHeight If {@code true}, the table row height will increase if necessary to accommodate new values.
     */
    public void setEnsureHeight(boolean ensureHeight) {
        this.ensureHeight = ensureHeight;
    }

// -- Rendering : --------------------------------------------------------------
    
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {

        if (value instanceof FormattedValue) {
            FormattedValue fv = (FormattedValue) value;
            super.getTableCellRendererComponent(table, fv.getText(), false, false, row, column);
            setBackground(fv.getBgColor());
            setForeground(fv.getFgColor());
            setHorizontalAlignment(fv.getHorizontalAlignment());
            setToolTipText(fv.getToolTip());
        } else if (value == null) {
            super.getTableCellRendererComponent(table, " ", false, false, row, column);
            TableColumn c = table.getColumnModel().getColumn(column);
//            System.out.println(column +" : "+ c.getMinWidth() +" "+ c.getPreferredWidth() +" "+ c.getMaxWidth());
            setBackground(MonitorFormat.COLOR_OFF);
            setHorizontalAlignment(SwingUtilities.CENTER);
        } else {
            super.getTableCellRendererComponent(table, value.toString(), false, false, row, column);
            setHorizontalAlignment(SwingUtilities.CENTER);
        }
        
//        System.out.println("renederer min: "+ getMinimumSize());

        if (ensureWidth) {
            int w = getMinimumSize().width + 2;
            TableColumn c = table.getColumnModel().getColumn(column);
            if (w > c.getMinWidth()) {
                c.setMinWidth(w);
            }
        }

        if (ensureHeight) {
            int h = getMinimumSize().height;
            if (h > table.getRowHeight(row)) {
                table.setRowHeight(row, h);
            }
        }
        
        return this;
    }

    @Override
    public Dimension getMinimumSize() {
//        System.out.println("Renderer min: "+ getPreferredSize());
        return getPreferredSize();
    }

}
