package org.lsst.ccs.gconsole.plugins.demo.monitor;

import java.util.*;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.messaging.AgentPresenceListener;

/**
 * Traditional style monitoring GUI demo.
 * Adopted from rafts subsystem.
 */
//@Plugin(name = "Trad Style Monitoring GUI Demo",
//        id="trad-mon-demo",
//        description = "Traditional style monitoring GUI demo plugin",
//        loadAtStart=false)
public class TradStylePlugin extends ConsolePlugin {
    
    private final List<String> monitoredSubsystems = Arrays.asList(new String[] {"demo-subsystem-with-monitoring", "monitor-test"});
    private final Map<String,TradMonitorGui> mapOfMonitorGuis = new HashMap<>();
    
    /** Called by the framework when the plugin is loaded. */
    @Override
    public void initialize() {
        getConsole().getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener(
                new AgentPresenceListener() {

                    @Override
                    public void connecting(AgentInfo agent) {
                        String name = agent.getName();
                        if (monitoredSubsystems.contains(name)) {
                            SwingUtilities.invokeLater(() -> {
                                if ( mapOfMonitorGuis.get(agent.getName()) == null ) {
                                    mapOfMonitorGuis.put(agent.getName(), openMonitorGui(name,getConsole()));
                                }
                            });
                        }
                    }

                    @Override
                    public void disconnecting(AgentInfo agent) {

                    }

                }
        );
    }
    
    private static TradMonitorGui openMonitorGui(String agentName, Console console) {
        TradMonitorGui gui = new TradMonitorGui(agentName);
        String title = agentName.replace("ccs-", "").replace("ccs","").toUpperCase()+" Monitor";
        console.getPanelManager().open(gui.getGuiLayout(), title);
        gui.initGui();
        return gui;
    }
    
}
