package org.lsst.ccs.gconsole.plugins.demo.monitor;

import java.awt.Color;
import java.awt.Font;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.monitor.data.MonitorState;
import org.lsst.ccs.subsystem.monitor.ui.CommandSender;

/**
 * Traditional monitoring panel.
 * Used by {@link TradStylePlugin}.
 */
public class TradMonitorPanel extends javax.swing.JPanel {

    static final Font f = new java.awt.Font("Tahoma", 1, 12);
    static final Color RED = new Color(150, 0, 0), GREEN = new Color(0, 150, 0);
    final private CommandSender gui;
    private String mainName;
    private double mainPeriod = 5;

    public TradMonitorPanel(CommandSender gui) {
        this.gui = gui;
        initComponents();
        lbMainState.setFont(f);
        lbMainStateValue.setFont(f);
        lbMainPeriod.setFont(f);
        lbMainPeriodUnits.setFont(f);
        (new UpdateRaftsStatus(TradMonitorGui.ID_MAIN, null)).run();
        (new DisableSystem(TradMonitorGui.ID_MAIN)).run();
    }

    public void setSubsystem(String mainName) {
        this.mainName = mainName;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        lbMainState = new javax.swing.JLabel();
        lbMainPeriod = new javax.swing.JLabel();
        lbMainStateValue = new javax.swing.JLabel();
        tfMainPeriod = new javax.swing.JTextField();
        lbMainPeriodUnits = new javax.swing.JLabel();

        lbMainState.setText("Rafts State:");
        lbMainState.setHorizontalTextPosition(javax.swing.SwingConstants.LEADING);

        lbMainPeriod.setText("Update Period:");

        lbMainStateValue.setText("....");

        tfMainPeriod.setText("...");
        tfMainPeriod.setMinimumSize(new java.awt.Dimension(50, 19));
        tfMainPeriod.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                tfMainPeriodActionPerformed(evt);
            }
        });

        lbMainPeriodUnits.setText("sec");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap(257, Short.MAX_VALUE)
                .addComponent(lbMainState)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(lbMainStateValue, javax.swing.GroupLayout.PREFERRED_SIZE, 72, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(90, 90, 90)
                .addComponent(lbMainPeriod)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(tfMainPeriod, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(lbMainPeriodUnits)
                .addContainerGap(246, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lbMainStateValue)
                    .addComponent(lbMainState)
                    .addComponent(lbMainPeriod, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(tfMainPeriod, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(lbMainPeriodUnits))
                .addContainerGap(71, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void tfMainPeriodActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_tfMainPeriodActionPerformed
        try {
            double value = Double.valueOf(tfMainPeriod.getText());
            gui.sendCommand(mainName, null, "setUpdatePeriod", (int)(1000 * value));
            tfMainPeriod.setEnabled(false);
        }
        catch(NumberFormatException nfe) {
            tfMainPeriod.setText(String.valueOf(mainPeriod));
        }
    }//GEN-LAST:event_tfMainPeriodActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel lbMainPeriod;
    private javax.swing.JLabel lbMainPeriodUnits;
    private javax.swing.JLabel lbMainState;
    private javax.swing.JLabel lbMainStateValue;
    private javax.swing.JTextField tfMainPeriod;
    // End of variables declaration//GEN-END:variables

    public void updateControlPanel(int id, MonitorState rs) {
        SwingUtilities.invokeLater(new UpdateRaftsStatus(id, rs));
    }

    public void disableSystem(int id) {
        SwingUtilities.invokeLater(new DisableSystem(id));
    }

    class UpdateRaftsStatus implements Runnable {

        private final int id;
        private final MonitorState rs;

        UpdateRaftsStatus(int id, MonitorState rs) {
            this.id = id;
            this.rs = rs;
        }

        @Override
        public void run() {
            if (id == TradMonitorGui.ID_MAIN) {
                lbMainStateValue.setText("RUNNING");
                lbMainStateValue.setForeground(GREEN);
                tfMainPeriod.setEnabled(true);
                mainPeriod = 5;
                tfMainPeriod.setText(String.valueOf(mainPeriod));
            }
        }

    }

    class DisableSystem implements Runnable {

        private final int id;

        DisableSystem(int id) {
            this.id = id;
        }

        @Override
        public void run() {
            if (id == TradMonitorGui.ID_MAIN) {
                lbMainStateValue.setText("STOPPED");
                lbMainStateValue.setForeground(RED);
                tfMainPeriod.setEnabled(false);
            }
        } 
    }

    private static final long serialVersionUID = 1L;
}
