package org.lsst.ccs.gconsole.agent;

/**
 * Mutable version of {@link AgentChannel}.
 *
 * @author onoprien
 */
public interface MutableAgentChannel extends AgentChannel {
    
    /**
     * Sets the value of the specified attribute.
     * The attribute value does not change if the new value is equal to the old one.
     * 
     * @param key The attribute is identified by the string returned by {@code toString()} method of the key object.
     *            If {@code key} is {@code null} or evaluates to {@link Key.VALUE}, the central value is set.
     * @param value The new value.
     * @return {@code true} if the attribute value has changed as a result of this call.
     */
    public boolean set(Object key, Object value);
    
    /**
     * Sets the value of this channel.
     * The value will not change if the new value is equal to the old one.
     * 
     * @param value New value.
     * @return {@code true} if the value has changed as a result of this call.
     */
    public boolean set(Object value);

}
