/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.awt.geom.AffineTransform;
import java.io.EOFException;
import java.io.IOException;
import org.freehep.graphicsio.swf.ColorXform;
import org.freehep.graphicsio.swf.ControlTag;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.graphicsio.swf.SWFTag;

public class PlaceObject
extends ControlTag {
    private int character;
    private int depth;
    private AffineTransform matrix;
    private ColorXform cxform = null;

    public PlaceObject(int id, int depth, AffineTransform matrix) {
        this(id, depth, matrix, null);
    }

    public PlaceObject(int id, int depth, AffineTransform matrix, ColorXform cxform) {
        this();
        this.character = id;
        this.depth = depth;
        this.matrix = matrix;
        this.cxform = cxform;
    }

    public PlaceObject() {
        super(4, 1);
    }

    @Override
    public SWFTag read(int tagID, SWFInputStream swf, int len) throws IOException {
        PlaceObject tag = new PlaceObject();
        tag.character = swf.readUnsignedShort();
        tag.depth = swf.readUnsignedShort();
        tag.matrix = swf.readMatrix();
        try {
            tag.cxform = new ColorXform(swf, false);
        }
        catch (EOFException e) {
            // empty catch block
        }
        return tag;
    }

    @Override
    public void write(int tagID, SWFOutputStream swf) throws IOException {
        swf.writeUnsignedShort(this.character);
        swf.writeUnsignedShort(this.depth);
        swf.writeMatrix(this.matrix);
        if (this.cxform != null) {
            this.cxform.write(swf, false);
        }
    }

    @Override
    public String toString() {
        return super.toString() + "\n" + "  depth: " + this.depth + "\n" + "  character: " + this.character + "\n" + "  matrix: " + this.matrix + "\n" + "  xform: " + this.cxform;
    }
}

