/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.commandbrowser;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.base.Const;
import org.lsst.ccs.gconsole.plugins.commandbrowser.BrowserFull;

public final class FilterDialog
extends JDialog {
    private final BrowserFull.Filter filter;

    private FilterDialog(BrowserFull.Filter filter, Component parentComponent) {
        super(parentComponent == null ? null : SwingUtilities.getWindowAncestor(parentComponent), "Filter target subsystems", Dialog.ModalityType.APPLICATION_MODAL);
        this.filter = filter;
        Box mainPanel = Box.createVerticalBox();
        this.add((Component)new JScrollPane(mainPanel), "Center");
        mainPanel.add(Box.createRigidArea(Const.VDIM));
        GridLayout gl = new GridLayout(0, 2);
        gl.setHgap(10);
        JPanel typePanel = new JPanel(gl);
        mainPanel.add(typePanel);
        typePanel.setBorder(BorderFactory.createTitledBorder("Type:"));
        for (AgentInfo.AgentType type : AgentInfo.AgentType.values()) {
            typePanel.add(new TypeBox(type));
        }
        mainPanel.add(Box.createRigidArea(Const.VDIM));
        Box namePanel = Box.createVerticalBox();
        mainPanel.add(namePanel);
        namePanel.setBorder(BorderFactory.createTitledBorder("Name:"));
        namePanel.add(new JLabel("<html>Comma-separated agent names:"));
        namePanel.add(Box.createRigidArea(Const.VDIM));
        namePanel.add(new NameField());
        mainPanel.add(Box.createRigidArea(Const.VDIM));
        Box groupPanel = Box.createVerticalBox();
        mainPanel.add(groupPanel);
        groupPanel.setBorder(BorderFactory.createTitledBorder("Group:"));
        groupPanel.add(new JLabel("<html>Comma-separated agent groups:"));
        groupPanel.add(Box.createRigidArea(Const.VDIM));
        groupPanel.add(new GroupField());
        mainPanel.add(Box.createRigidArea(Const.VDIM));
        Box propertiesPanel = Box.createVerticalBox();
        mainPanel.add(propertiesPanel);
        propertiesPanel.setBorder(BorderFactory.createTitledBorder("Properties:"));
        propertiesPanel.add(new JLabel("<html>Comma-separated list of agent properties in key[=value] format. \"null\" value indicates testing for the absence of the property."));
        propertiesPanel.add(Box.createRigidArea(Const.VDIM));
        propertiesPanel.add(new PropertiesField());
        mainPanel.add(Box.createRigidArea(Const.VDIM));
        mainPanel.add(Box.createVerticalGlue());
        Box buttonPanel = Box.createHorizontalBox();
        buttonPanel.add(Box.createHorizontalGlue());
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(e -> {
            this.dispose();
            filter.restore();
            filter.apply();
        });
        buttonPanel.add(cancel);
        buttonPanel.add(Box.createRigidArea(Const.HDIM));
        JButton ok = new JButton("  OK  ");
        ok.addActionListener(e -> {
            this.dispose();
            filter.save();
        });
        buttonPanel.add(ok);
        buttonPanel.add(Box.createRigidArea(Const.HDIM));
        this.add((Component)buttonPanel, "South");
    }

    static void show(BrowserFull.Filter filter, Component parentComponent) {
        if (parentComponent != null) {
            parentComponent = SwingUtilities.getWindowAncestor(parentComponent);
        }
        FilterDialog dialog = new FilterDialog(filter, parentComponent);
        dialog.setSize(dialog.getPreferredSize());
        dialog.pack();
        dialog.setLocationRelativeTo(parentComponent);
        dialog.setVisible(true);
    }

    private final class PropertiesField
    extends JTextField {
        PropertiesField() {
            super(20);
            this.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.getPreferredSize().height));
            if (((FilterDialog)FilterDialog.this).filter.properties != null) {
                ArrayList ss = new ArrayList(((FilterDialog)FilterDialog.this).filter.properties.size());
                ((FilterDialog)FilterDialog.this).filter.properties.forEach((key, value) -> {
                    if (value == null) {
                        key = key + "=null";
                    } else if (!value.isEmpty()) {
                        key = key + "=" + value;
                    }
                    ss.add(key);
                });
                this.setText(String.join((CharSequence)",", ss));
            }
            this.addCaretListener(e -> {
                String text = this.getText();
                if (text.trim().isEmpty()) {
                    ((FilterDialog)FilterDialog.this).filter.properties = null;
                } else {
                    String[] ss = text.split(",");
                    ((FilterDialog)FilterDialog.this).filter.properties = new HashMap();
                    for (String s : ss) {
                        String[] sss = s.split("=");
                        if (sss.length <= 0) continue;
                        String key = sss[0].trim();
                        if (sss.length > 1) {
                            String value = sss[1].trim();
                            if (value.equalsIgnoreCase("null")) {
                                value = null;
                            }
                            ((FilterDialog)FilterDialog.this).filter.properties.putIfAbsent(key, value);
                            continue;
                        }
                        ((FilterDialog)FilterDialog.this).filter.properties.putIfAbsent(key, "");
                    }
                }
                FilterDialog.this.filter.apply();
            });
        }
    }

    private final class GroupField
    extends JTextField {
        GroupField() {
            super(20);
            if (((FilterDialog)FilterDialog.this).filter.groups != null) {
                this.setText(String.join((CharSequence)",", ((FilterDialog)FilterDialog.this).filter.groups));
            }
            this.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.getPreferredSize().height));
            this.addCaretListener(e -> {
                String text = this.getText();
                if (text.trim().isEmpty()) {
                    ((FilterDialog)FilterDialog.this).filter.groups = null;
                } else {
                    String[] ss = text.split(",");
                    ((FilterDialog)FilterDialog.this).filter.groups = new ArrayList(ss.length);
                    for (String s : ss) {
                        ((FilterDialog)FilterDialog.this).filter.groups.add(s.trim());
                    }
                }
                FilterDialog.this.filter.apply();
            });
        }
    }

    private final class NameField
    extends JTextField {
        NameField() {
            super(20);
            if (((FilterDialog)FilterDialog.this).filter.names != null) {
                this.setText(String.join((CharSequence)",", ((FilterDialog)FilterDialog.this).filter.names));
            }
            this.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.getPreferredSize().height));
            this.addCaretListener(e -> {
                String text = this.getText();
                if (text.trim().isEmpty()) {
                    ((FilterDialog)FilterDialog.this).filter.names = null;
                } else {
                    String[] ss = text.split(",");
                    ((FilterDialog)FilterDialog.this).filter.names = new ArrayList(ss.length);
                    for (String s : ss) {
                        ((FilterDialog)FilterDialog.this).filter.names.add(s.trim());
                    }
                }
                FilterDialog.this.filter.apply();
            });
        }
    }

    private final class TypeBox
    extends JCheckBox {
        private final AgentInfo.AgentType type;

        TypeBox(AgentInfo.AgentType type) {
            super(type.displayName());
            this.type = type;
            this.setSelected(((FilterDialog)FilterDialog.this).filter.types == null || ((FilterDialog)FilterDialog.this).filter.types.contains(type));
            this.addActionListener(e -> {
                if (this.isSelected()) {
                    ((FilterDialog)FilterDialog.this).filter.types.add(this.type);
                    if (((FilterDialog)FilterDialog.this).filter.types.size() == AgentInfo.AgentType.values().length) {
                        ((FilterDialog)FilterDialog.this).filter.types = null;
                    }
                } else {
                    if (((FilterDialog)FilterDialog.this).filter.types == null) {
                        ((FilterDialog)FilterDialog.this).filter.types = EnumSet.allOf(AgentInfo.AgentType.class);
                    }
                    ((FilterDialog)FilterDialog.this).filter.types.remove(this.type);
                }
                FilterDialog.this.filter.apply();
            });
        }
    }
}

