/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter;

import hep.aida.IMarkerStyle;
import hep.aida.ref.plotter.BrushStyle;
import hep.aida.ref.plotter.IntegerStyleParameter;
import hep.aida.ref.plotter.RevolvingStyleParameter;
import hep.aida.ref.plotter.StringStyleParameter;
import hep.aida.ref.plotter.Style;
import java.util.Iterator;
import java.util.List;

public class MarkerStyle
extends BrushStyle
implements IMarkerStyle {
    @Override
    protected void initializeBaseStyle() {
        super.initializeBaseStyle();
        String[] availShapes = new String[]{"dot", "box", "triangle", "diamond", "star", "verticalLine", "horizontalLine", "cross", "circle", "square"};
        this.addParameter(new StringStyleParameter("shape", null, availShapes));
        this.addParameter(new RevolvingStyleParameter("shapeRotate", availShapes[0]));
        this.addParameter(new StringStyleParameter("shapeRotateMethod", Style.ROTATE_METHOD[1], Style.ROTATE_METHOD));
        this.addParameter(new IntegerStyleParameter("size", 6));
        String defaultRotation = "dot, box, triangle, diamond, star, circle, square";
        this.setParameterDefault("shapeRotate", defaultRotation);
    }

    public String[] availableShapes() {
        return this.availableParameterOptions("shape");
    }

    public boolean setShape(String markerShape) {
        return ((StringStyleParameter)this.parameter("shape")).setValue(markerShape);
    }

    public String shape() {
        return ((StringStyleParameter)this.deepestSetParameter("shape")).value();
    }

    public String shape(int globalIndex, int overlayIndex) {
        if (this.isParameterSet("shape", false)) {
            return this.parameter("shape").parValue();
        }
        if (this.isParameterSet("shapeRotate", false)) {
            if (this.parameterValue("shapeRotate") == Style.ROTATE_METHOD[0]) {
                return ((RevolvingStyleParameter)this.parameter("shapeRotate")).parameterValue(globalIndex);
            }
            return ((RevolvingStyleParameter)this.parameter("shapeRotate")).parameterValue(overlayIndex);
        }
        List parents = this.parentList();
        if (parents != null) {
            Iterator it = parents.iterator();
            while (it.hasNext()) {
                String tmp;
                MarkerStyle pbs = null;
                Object obj = it.next();
                if (!(obj instanceof MarkerStyle) || (tmp = (pbs = (MarkerStyle)obj).shape(globalIndex, overlayIndex)) == null) continue;
                return tmp;
            }
        }
        return null;
    }

    public boolean setSize(int size) {
        return ((IntegerStyleParameter)this.parameter("size")).setValue(size);
    }

    public int size() {
        return ((IntegerStyleParameter)this.deepestSetParameter("size")).value();
    }
}

