package org.lsst.ccs.gconsole.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation that identifies graphical console plugins.
 *
 * @author onoprien
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface Plugin {
    String id() default "";
    String name() default "";
    String author() default "LSST CCS Team";
    String version() default "${project.version}";
    String category() default "projects.lsst";
    String shortDescription() default "";
    String description() default "";
    boolean loadAtStart() default true;
}
