package org.lsst.ccs.gconsole.annotations.services.persist;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotates methods and constructors to be used as instance factories by the persistence service.
 *
 * @author onoprien
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD, ElementType.CONSTRUCTOR, ElementType.LOCAL_VARIABLE})
public @interface Create {
    String category() default "";
    String name() default "";
    String path();
    String description() default "";
    
    static final String RESOURCE = "gui/creators.txt";
}
