package org.lsst.ccs.subsystem.vacuum;

import org.lsst.ccs.drivers.commons.DriverException;

/**
 *  Handles the simulated MAQ20 device.
 *
 *  @author Owen Saxton
 */
public class SimMaq20Device extends org.lsst.ccs.subsystem.common.devices.dataforth.SimMaq20Device {


    /**
     *  Sets initial channel values.
     */
    @Override
    public void postStart()
    {
        for (String chanPath : channelMap.keySet()) {
            try {
                setChannelValue(chanPath, 90.0 + Math.random());
            }
            catch (DriverException e) {}  // Just ignore it
        }
    }

}
