/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb.server;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.lsst.ccs.localdb.statusdb.model.DataDesc;
import org.lsst.ccs.localdb.statusdb.model.DataPath;
import org.lsst.ccs.localdb.statusdb.server.HashMapEntry4XML;
import org.lsst.ccs.localdb.statusdb.trendServer.RestServer;

@XmlRootElement(name="datachannel")
public class DataChannel
implements Serializable {
    private static final long serialVersionUID = -9154127909107314678L;
    protected long id;
    @XmlElement(name="pathelement")
    @XmlElementWrapper
    protected String[] path;
    Map<String, String> metadata = new HashMap<String, String>();

    public DataChannel(DataDesc desc) {
        this.path = desc.getDataPath().getPath();
        this.setId(desc.getId());
    }

    public DataChannel() {
    }

    @XmlElement
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String[] getPath() {
        return this.path;
    }

    public String getPathAsString() {
        return DataPath.encodePath(this.path);
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @XmlElement(name="metadata")
    List<HashMapEntry4XML> getMetadataList() {
        return HashMapEntry4XML.marshal(this.metadata);
    }

    @XmlRootElement(name="datachannels")
    public static class DataChannelList {
        @XmlElement(name="datachannel")
        public List<DataChannel> list;
        @XmlAttribute
        private Date activeSinceDate;
        @XmlAttribute
        private String host;
        @XmlAttribute
        private int port;

        public DataChannelList(List<DataChannel> list, long milliseconds) {
            this.list = list;
            this.activeSinceDate = new Date(milliseconds);
            this.host = RestServer.getRestServerHost();
            this.port = RestServer.getRestServerPort();
        }

        public DataChannelList() {
        }

        public Date getActiveSinceDate() {
            return this.activeSinceDate;
        }

        public int getPort() {
            return this.port;
        }

        public String getHost() {
            return this.host;
        }
    }
}

