/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ascii;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.ascii.AsciiIO;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.serial.SerialPort;

public class AsciiIOSerial
implements AsciiIO {
    private static final Map<Integer, Integer> dbitsMap = new HashMap<Integer, Integer>();
    private static final Map<Integer, Integer> sbitsMap;
    private static final Map<Integer, Integer> parityMap;
    private final SerialPort port = new SerialPort();
    private int timeout;

    @Override
    public void open(String dname, int baud, int dchar) throws DriverException {
        Integer dataBits = dbitsMap.get(dchar >> 24 & 0xFF);
        if (dataBits == null) {
            throw new DriverException("Invalid number of data bits");
        }
        Integer stopBits = sbitsMap.get(dchar >> 16 & 0xFF);
        if (stopBits == null) {
            throw new DriverException("Invalid number of stop bits");
        }
        Integer parity = parityMap.get(dchar >> 8 & 0xFF);
        if (parity == null) {
            throw new DriverException("Invalid parity");
        }
        int fc = dchar & 0xFF;
        int flowCtrl = ((fc & 1) != 0 ? 3 : 0) | ((fc & 4) != 0 ? 12 : 0);
        this.port.openPort(dname);
        this.port.setParams(baud, dataBits, stopBits, parity);
        this.port.setFlowControlMode(flowCtrl);
    }

    @Override
    public void close() throws DriverException {
        this.port.closePort();
    }

    @Override
    public void write(byte[] buff, int offset, int leng) throws DriverException {
        this.port.writeBytes(buff, offset, leng);
    }

    @Override
    public int read(byte[] buff, int offset, int mleng) throws DriverException {
        return this.port.read(buff, offset, mleng, this.timeout);
    }

    @Override
    public void flush() throws DriverException {
        this.port.readBytes();
    }

    @Override
    public void setTimeout(int timeout) throws DriverException {
        this.timeout = timeout;
    }

    static {
        dbitsMap.put(1, 7);
        dbitsMap.put(0, 8);
        sbitsMap = new HashMap<Integer, Integer>();
        sbitsMap.put(0, 1);
        sbitsMap.put(1, 2);
        parityMap = new HashMap<Integer, Integer>();
        parityMap.put(0, 0);
        parityMap.put(1, 1);
        parityMap.put(2, 2);
        parityMap.put(3, 3);
        parityMap.put(4, 4);
    }
}

