package org.lsst.ccs.subsystem.vacuum;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;

/**
 *  Interface to a simulated MKS 972/974/925 vacuum gauge.
 *
 *  @author Owen Saxton
 */
public class SimMks9xxDevice extends Device {

    /**
     *  Data fields.
     */
    private static final Logger LOG = Logger.getLogger(SimMks9xxDevice.class.getName());
    private double vacValue = 760.0;
    private boolean isOnline = true;


    /**
     *  Performs configuration.
     */
    @Override
    public void initDevice() {
        fullName = "Simulated MKS model 9XX";
    }


    /**
     *  Performs full initialization.
     */
    @Override
    public void initialize()
    {
        if (isOnline) {
            super.setOnline(true);
            LOG.log(Level.INFO, "Connected to {0}", fullName);
        }
    }


    /**
     *  Closes the connection.
     */
    @Override
    public void close()
    {
    }


    /**
     *  Reads a monitoring channel.
     *
     *  @param  ch  The channel to read
     *  @return  The read value
     */
    @Override
    public double readChannel(Channel ch)
    {
        return vacValue;
    }


    /**
     *  Sets the pressure.
     *
     *  @param  pressure  The simulated pressure
     */
    @Command(type=Command.CommandType.ACTION, level=0, description="Set the pressure")
    public void setPressure(@Argument(description="Pressure value") double pressure)
    {
        vacValue = pressure;
    }    


    /**
     *  Sets the device on- or off-line.
     *
     *  @param  on  Whether online or not
     */
    @Command(type=Command.CommandType.ACTION, level=0, description="Set online state")
    @Override
    public void setOnline(@Argument(description="Whether online") boolean on)
    {
        isOnline = on;
        if (!isOnline) {
            super.setOnline(false);
        }
    }    

}
