/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.connection;

import java.util.Properties;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.framework.HasLifecycle;

public class ConnectionParameters
implements HasLifecycle {
    @ConfigurationParameter(isFinal=true, category="DbConnection")
    private volatile String url;
    @ConfigurationParameter(isFinal=true, category="DbConnection")
    private volatile String username;
    @ConfigurationParameter(isFinal=true, category="DbConnection")
    private volatile String password;
    @ConfigurationParameter(isFinal=true, category="DbConnection")
    private volatile String dialect;
    @ConfigurationParameter(isFinal=true, category="DbConnection")
    private volatile String driver_class;
    private Properties connectionProperties = new Properties();

    public void init() {
        if (this.url == null) {
            throw new RuntimeException("Database url configuration parameter must be specified.");
        }
        this.connectionProperties.setProperty("hibernate.connection.url", this.url);
        if (this.username != null) {
            this.connectionProperties.setProperty("hibernate.connection.username", this.username);
        }
        if (this.password != null) {
            this.connectionProperties.setProperty("hibernate.connection.password", this.password);
        }
        if (this.driver_class != null) {
            this.connectionProperties.setProperty("hibernate.connection.driver_class", this.driver_class);
        }
        if (this.driver_class != null) {
            this.connectionProperties.setProperty("hibernate.dialect", this.dialect);
        }
    }

    public Properties getConnectionProperties() {
        return this.connectionProperties;
    }
}

