/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb.model;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.QueryHint;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.lsst.ccs.localdb.statusdb.model.RawData;
import org.lsst.ccs.localdb.statusdb.model.StatDesc;
import org.lsst.ccs.localdb.statusdb.model.StatTimeInterval;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"statDescId", "statTimeIntervalId"})}, indexes={@Index(columnList="statDescId, statTimeIntervalId")})
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="org.lsst.ccs.localdb.statusdb.model.StatData")
@NamedQueries(value={@NamedQuery(name="findStatData", query="from StatData s where s.statDesc=:d and s.statTimeInterval=:sti", hints={@QueryHint(name="org.hibernate.cacheable", value="true")})})
public class StatData
implements Serializable {
    static final Logger log = Logger.getLogger("org.lsst.ccs.localdb.statusdb");
    private static final long serialVersionUID = -8845106173875848941L;
    private long id;
    private StatDesc statDesc;
    private StatTimeInterval timeInterval;
    private double average;
    private double sum2;
    private int n;
    private double minval;
    private double maxval;

    public StatData() {
    }

    public StatData(StatDesc d, RawData x, StatTimeInterval timeInterval) {
        log.fine("new StatData from " + d.getDataDesc().getDataPath().getFullKey() + " : " + x.getDoubleData() + " at " + x.getTime());
        this.statDesc = d;
        this.average = x.getDoubleData();
        this.sum2 = this.average * this.average;
        this.minval = this.average;
        this.maxval = this.average;
        this.n = 1;
        this.timeInterval = timeInterval;
    }

    @Transient
    public double getSum() {
        return this.getAverage() * (double)this.getN();
    }

    public void setSum(double s) {
        this.setAverage(s / (double)this.getN());
    }

    @Transient
    public double getStdDev() {
        return Math.sqrt(this.getSum2() / (double)this.getN() - this.getAverage() * this.getAverage());
    }

    public void accumulate(RawData x) {
        double sum = this.getSum();
        double d = x.getDoubleData();
        if (!Double.isFinite(d)) {
            log.log(Level.WARNING, "Ignoring non finite value {0} for channel {1}", new Object[]{d, x.getDataDesc().getDataPath().getFullKey()});
            return;
        }
        sum += d;
        this.setSum2(this.getSum2() + d * d);
        if (this.getN() == 0 || d > this.maxval) {
            this.maxval = d;
        }
        if (this.getN() == 0 || d < this.minval) {
            this.minval = d;
        }
        this.setN(this.getN() + 1);
        this.setSum(sum);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @ManyToOne(optional=false, cascade={CascadeType.MERGE})
    @JoinColumn(name="statDescId", updatable=false)
    public StatDesc getStatDesc() {
        return this.statDesc;
    }

    public void setStatDesc(StatDesc statDesc) {
        this.statDesc = statDesc;
    }

    @ManyToOne(optional=false, cascade={CascadeType.MERGE})
    @JoinColumn(name="statTimeIntervalId", updatable=false)
    public StatTimeInterval getStatTimeInterval() {
        return this.timeInterval;
    }

    public void setStatTimeInterval(StatTimeInterval timeInterval) {
        this.timeInterval = timeInterval;
    }

    public double getAverage() {
        return this.average;
    }

    public void setAverage(double average) {
        this.average = average;
    }

    public double getSum2() {
        return this.sum2;
    }

    public void setSum2(double sum2) {
        this.sum2 = sum2;
    }

    public int getN() {
        return this.n;
    }

    public void setN(int n) {
        this.n = n;
    }

    public void setMin(double min) {
        this.minval = min;
    }

    @Column(name="minval")
    public double getMin() {
        return this.minval;
    }

    public void setMax(double max) {
        this.maxval = max;
    }

    @Column(name="maxval")
    public double getMax() {
        return this.maxval;
    }
}

