/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.configdb.model;

import java.io.Serializable;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.lsst.ccs.localdb.configdb.model.ConfigurationParameter;
import org.lsst.ccs.localdb.configdb.model.ParameterPath;
import org.lsst.ccs.localdb.configdb.model.PathObject;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"configurationParameterId", "value", "tChanged"})})
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="org.lsst.ccs.localdb.configdb.model.ConfigurationParameterValue")
public class ConfigurationParameterValue
implements Serializable,
PathObject {
    private static final long serialVersionUID = 774337848554181101L;
    private long id;
    private ConfigurationParameter configurationParameter;
    private String value;
    private long tChanged;

    protected ConfigurationParameterValue() {
    }

    public ConfigurationParameterValue(ConfigurationParameter configurationParameter, String value, long tChanged) {
        this.configurationParameter = configurationParameter;
        this.value = value;
        this.tChanged = tChanged;
    }

    public String getValue() {
        return this.value;
    }

    void setValue(String value) {
        this.value = value;
    }

    @Override
    @Transient
    public ParameterPath getPath() {
        return this.configurationParameter.getPath();
    }

    @Id
    @GeneratedValue(generator="ID_SEQUENCE_GENERATOR")
    public long getId() {
        return this.id;
    }

    protected void setId(long id) {
        this.id = id;
    }

    public long getTChanged() {
        return this.tChanged;
    }

    public void setTChanged(long tchanged) {
        this.tChanged = tchanged;
    }

    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    ConfigurationParameter getConfigurationParameter() {
        return this.configurationParameter;
    }

    void setConfigurationParameter(ConfigurationParameter parameterDescription) {
        this.configurationParameter = parameterDescription;
    }

    public String toString() {
        return this.getId() + "{" + this.getId() + ": description=" + this.configurationParameter + ", value='" + this.value + '\'' + '}';
    }
}

