package org.lsst.ccs.subsystem.vacuum;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.subsystem.vacuum.data.VacSysState;

/**
 *  Definitions of the vacuum system switch names.
 *
 *  @author The CCS team
 */
public class SwitchNames {

    public static final String
        CRYO_TURBO     = "CryoTurbo",
        CRYO_ION_PUMP1 = "CryoIon1",
        CRYO_ION_PUMP2 = "CryoIon2",
        CRYO_ION_PUMP3 = "CryoIon3",
        CRYO_ION_PUMP4 = "CryoIon4",
        CRYO_ION_PUMP5 = "CryoIon5",
        CRYO_ION_PUMP6 = "CryoIon6",
        CRYO_VALVE     = "CryoValve",
        HX_TURBO       = "HxTurbo",
        HX_ION_PUMP1   = "HxIon1",
        HX_ION_PUMP2   = "HxIon2",
        HX_VALVE       = "HxValve",
        OR_ION_PUMP    = "OrIon",
        OR_FPP_VALVE   = "OrFppValve",
        OR_FH_VALVE    = "OrFhValve",
        OR_L3H_VALVE   = "OrL3hValve",
        OR_L3_VALVE    = "OrL3Valve";

    public static final Map<String, Integer> NAME_MAP = new HashMap<>();
    static {
        NAME_MAP.put(CRYO_TURBO, VacSysState.SW_CRYO_TURBO);
        NAME_MAP.put(CRYO_ION_PUMP1, VacSysState.SW_CRYO_ION_PUMP1);
        NAME_MAP.put(CRYO_ION_PUMP2, VacSysState.SW_CRYO_ION_PUMP2);
        NAME_MAP.put(CRYO_ION_PUMP3, VacSysState.SW_CRYO_ION_PUMP3);
        NAME_MAP.put(CRYO_ION_PUMP4, VacSysState.SW_CRYO_ION_PUMP4);
        NAME_MAP.put(CRYO_ION_PUMP5, VacSysState.SW_CRYO_ION_PUMP5);
        NAME_MAP.put(CRYO_ION_PUMP6, VacSysState.SW_CRYO_ION_PUMP6);
        NAME_MAP.put(CRYO_VALVE, VacSysState.SW_CRYO_VALVE);
        NAME_MAP.put(HX_TURBO, VacSysState.SW_HX_TURBO);
        NAME_MAP.put(HX_ION_PUMP1, VacSysState.SW_HX_ION_PUMP1);
        NAME_MAP.put(HX_ION_PUMP2, VacSysState.SW_HX_ION_PUMP2);
        NAME_MAP.put(HX_VALVE, VacSysState.SW_HX_VALVE);
    }

}
