/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.dataforth;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.dataforth.Maq20;

public class Maq20Discrete {
    final Maq20 maq;
    final Maq20.ModuleData module;
    private static final short DISCR_CONFIG_ADDR = 100;
    private static final short CHAN_DATA_ADDR = 1000;

    public Maq20Discrete(Maq20 maq, int modId) throws DriverException {
        this.maq = maq;
        this.module = maq.getModuleData(modId, false);
        if (this.module.opType != 2) {
            throw new DriverException("Invalid module type (" + (Object)((Object)this.module.type) + ") for discrete operations");
        }
    }

    public int[] readDiscIn(int chan, int count) throws DriverException {
        int nChan = count >= 0 ? count : this.module.numInChan - chan;
        this.checkInputChannel(chan, nChan);
        if (nChan == 0) {
            return new int[0];
        }
        short addr = (short)(this.module.baseAddr + 1000 + this.module.numOutChan + chan);
        short[] raw = this.maq.readRegisters(addr, (short)nChan);
        int[] data = new int[nChan];
        for (int j = 0; j < data.length; ++j) {
            data[j] = raw[j];
        }
        return data;
    }

    public int readDiscIn(int chan) throws DriverException {
        return this.readDiscIn(chan, 1)[0];
    }

    public int[] readDiscIn() throws DriverException {
        return this.readDiscIn(0, -1);
    }

    public int[] readDiscOut(int chan, int count) throws DriverException {
        int nChan = count >= 0 ? count : this.module.numOutChan - chan;
        this.checkOutputChannel(chan, nChan);
        if (nChan == 0) {
            return new int[0];
        }
        short addr = (short)(this.module.baseAddr + 1000 + chan);
        short[] raw = this.maq.readRegisters(addr, (short)nChan);
        int[] data = new int[nChan];
        for (int j = 0; j < data.length; ++j) {
            data[j] = raw[j];
        }
        return data;
    }

    public int readDiscOut(int chan) throws DriverException {
        return this.readDiscOut(chan, 1)[0];
    }

    public int[] readDiscOut() throws DriverException {
        return this.readDiscOut(0, -1);
    }

    public void writeDisc(int chan, int count, int[] data) throws DriverException {
        int nChan = count >= 0 ? count : this.module.numOutChan - chan;
        this.checkOutputChannel(chan, nChan);
        if (nChan == 0) {
            return;
        }
        short[] raw = new short[nChan];
        for (int j = 0; j < data.length; ++j) {
            raw[j] = (short)data[j];
        }
        this.maq.writeRegisters((short)(this.module.baseAddr + 1000 + chan), raw);
    }

    public void writeDisc(int chan, int data) throws DriverException {
        this.writeDisc(chan, 1, new int[]{data});
    }

    public void writeDisc(int[] data) throws DriverException {
        this.writeDisc(0, -1, data);
    }

    private void checkInputChannel(int chan, int count) throws DriverException {
        if (chan < 0 || chan >= this.module.numInChan) {
            throw new DriverException("Invalid input channel number");
        }
        if (count < 0 || chan + count > this.module.numInChan) {
            throw new DriverException("Invalid input channel count");
        }
    }

    private void checkOutputChannel(int chan, int count) throws DriverException {
        if (chan < 0 || chan >= this.module.numOutChan) {
            throw new DriverException("Invalid output channel number");
        }
        if (count < 0 || chan + count > this.module.numOutChan) {
            throw new DriverException("Invalid output channel count");
        }
    }
}

