/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.monitor;

import java.lang.reflect.Constructor;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Control;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.utilities.logging.Logger;

public abstract class Device
implements HardwareController,
HasLifecycle {
    protected String fullName;
    protected final BitSet chanMask = new BitSet();
    protected boolean disabled;
    protected boolean inited;
    protected boolean online;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected Monitor mon;
    protected final Logger log = Logger.getLogger((String)"org.lsst.ccs.monitor.device");
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    protected final Map<String, Control> ctlChans = new LinkedHashMap<String, Control>();
    protected int lineMask;
    protected int lineWarm;
    protected int lineState;
    @LookupField(strategy=LookupField.Strategy.TOP)
    protected Subsystem s;
    @LookupName
    protected String name;

    @Override
    public void init() {
        this.initDevice();
        this.configure(this.mon);
    }

    protected void initDevice() {
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public boolean isOnline() {
        return this.online;
    }

    public void disable() {
        this.disabled = true;
        this.setOnline(false);
    }

    public void enable() {
        this.disabled = false;
        this.checkOnline();
    }

    protected void configure(Monitor mon) {
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        return new int[]{0, 0};
    }

    protected abstract void initialize();

    protected abstract void close();

    protected void initSensors() {
        int id = this.chanMask.nextSetBit(0);
        while (id >= 0) {
            this.mon.getChannel(id).initSensor();
            id = this.chanMask.nextSetBit(id + 1);
        }
    }

    protected void initChannel(int hwChan, int type, int subtype) {
    }

    protected void initChannel(String name, int id, int hwChan, int type, int subtype) {
        this.initChannel(hwChan, type, subtype);
    }

    protected void addChannel(int id) {
        this.chanMask.set(id);
    }

    protected void dropChannel(int id) {
        this.chanMask.clear(id);
        BitSet mask = new BitSet(id);
        mask.set(id);
        this.mon.getChannel(id).setValid(false);
    }

    public void checkOnline() {
        this.log.debug((Object)("Checking if device is online (" + this.online + ") or disabled (" + this.disabled + ")"));
        if (this.online || this.disabled) {
            return;
        }
        try {
            this.initialize();
        }
        catch (Exception e) {
            this.log.warn((Object)("Failed to initialize " + this.name), (Throwable)e);
        }
    }

    protected boolean testOnline() {
        if (!this.online) {
            this.log.error((Object)("Device " + this.fullName + " is offline"));
        }
        return this.online;
    }

    protected void setOnline(boolean online) {
        if (this.online == online) {
            return;
        }
        this.online = online;
        if (!online) {
            if (!this.disabled) {
                this.log.error((Object)("Disconnected from " + this.fullName));
            }
            this.close();
        }
    }

    protected void readSensors() {
        this.readChannelGroup();
        int id = this.chanMask.nextSetBit(0);
        while (id >= 0) {
            this.mon.getChannel(id).readSensor();
            id = this.chanMask.nextSetBit(id + 1);
        }
    }

    protected void readChannelGroup() {
    }

    protected double readChannel(int hwChan, int type) {
        return Double.NaN;
    }

    protected double readChannel(Channel ch) {
        return this.readChannel(ch.hwChan, ch.typeI);
    }

    protected double readChannelNow(int hwChan, int type) {
        return this.readChannel(hwChan, type);
    }

    @Deprecated
    protected void checkTimeout(Exception e, Class<?> eClass) throws Exception {
        if (this.isTimeout(e)) {
            this.setOnline(false);
        }
        Constructor<?> eCon = eClass.getConstructor(String.class);
        throw (Exception)eCon.newInstance(e.getMessage());
    }

    @Deprecated
    protected boolean isTimeout(Exception e) {
        return e.getMessage().matches(".*time.*out.*");
    }

    protected final void checkLine(String name, int line) throws Exception {
        this.checkHwLine(name, line);
    }

    protected void checkHwLine(String name, int line) throws Exception {
    }

    protected void setLineWarm(int line, boolean on) {
        this.lineWarm = on ? (this.lineWarm |= 1 << line) : (this.lineWarm &= ~(1 << line));
    }

    protected final void setLine(int line, boolean on) {
        this.lineState = on ? (this.lineState |= 1 << line) : (this.lineState &= ~(1 << line));
        this.setHwLine(line, on);
    }

    protected void setHwLine(int line, boolean on) {
    }

    protected final Boolean isLineSet(int line) {
        return this.isHwLineSet(line);
    }

    protected Boolean isHwLineSet(int line) {
        return null;
    }

    protected void setOutputLines() {
        int mask = this.lineMask;
        int line = 0;
        while (mask != 0) {
            if ((mask & 1) != 0) {
                if ((this.lineWarm & 1 << line) == 0) {
                    this.setLine(line, (this.lineState & 1 << line) != 0);
                } else {
                    Boolean set = this.isHwLineSet(line);
                    if (set != null) {
                        this.setLine(line, set);
                    }
                }
            }
            mask >>>= 1;
            ++line;
        }
    }

    protected void getOutputLines() {
        this.lineState = 0;
        int mask = this.lineMask;
        int line = 0;
        while (mask != 0) {
            if ((mask & 1) != 0) {
                Boolean set = this.isHwLineSet(line);
                this.lineState |= set != null && set != false ? 1 << line : 0;
            }
            mask >>>= 1;
            ++line;
        }
    }

    protected void addLine(int line) {
        this.lineMask |= 1 << line;
    }

    @Override
    public TreeWalkerDiag checkHardware() throws HardwareException {
        if (!this.disabled) {
            try {
                this.initialize();
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to initialize " + this.name), (Throwable)e);
                throw new HardwareException(false, e);
            }
        }
        return TreeWalkerDiag.GO;
    }
}

