/*
 * Decompiled with CFR 0.152.
 */
package com.wittams.gritty.jsch;

import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import com.wittams.gritty.Questioner;
import com.wittams.gritty.Tty;
import com.wittams.gritty.jsch.QuestionerUserInfo;
import com.wittams.gritty.swing.standalone.Main;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class JSchTty
implements Tty {
    private InputStream in = null;
    private OutputStream out = null;
    private Session session;
    private ChannelShell channel;
    private int port = 22;
    private String user = null;
    private String host = null;
    private String password = null;
    private Dimension pendingTermSize;
    private Dimension pendingPixelSize;

    public JSchTty() {
    }

    public JSchTty(String host, String user, String password) {
        this.host = host;
        this.user = user;
        this.password = password;
    }

    @Override
    public void resize(Dimension termSize, Dimension pixelSize) {
        this.pendingTermSize = termSize;
        this.pendingPixelSize = pixelSize;
        if (this.channel != null) {
            this.resizeImmediately();
        }
    }

    private void resizeImmediately() {
        if (this.pendingTermSize != null && this.pendingPixelSize != null) {
            this.channel.setPtySize(this.pendingTermSize.width, this.pendingTermSize.height, this.pendingPixelSize.width, this.pendingPixelSize.height);
            this.pendingTermSize = null;
            this.pendingPixelSize = null;
        }
    }

    @Override
    public void close() {
        if (this.session != null) {
            this.session.disconnect();
            this.session = null;
            this.channel = null;
            this.in = null;
            this.out = null;
        }
    }

    @Override
    public boolean init(Questioner q) {
        this.getAuthDetails(q);
        try {
            this.session = this.connectSession(q);
            this.channel = (ChannelShell)this.session.openChannel("shell");
            this.in = this.channel.getInputStream();
            this.out = this.channel.getOutputStream();
            this.channel.connect();
            this.resizeImmediately();
            return true;
        }
        catch (IOException e) {
            q.showMessage(e.getMessage());
            Main.logger.error((Object)"Error opening channel", (Throwable)e);
            return false;
        }
        catch (JSchException e) {
            q.showMessage(e.getMessage());
            Main.logger.error((Object)"Error opening session or channel", (Throwable)e);
            return false;
        }
    }

    private Session connectSession(Questioner questioner) throws JSchException {
        JSch jsch = new JSch();
        Session session = null;
        session = jsch.getSession(this.user, this.host, this.port);
        QuestionerUserInfo ui = new QuestionerUserInfo(questioner);
        if (this.password != null) {
            session.setPassword(this.password);
            ui.setPassword(this.password);
        }
        session.setUserInfo((UserInfo)ui);
        Properties config = new Properties();
        config.put("compression.s2c", "zlib,none");
        config.put("compression.c2s", "zlib,none");
        this.configureSession(session, config);
        session.setTimeout(5000);
        session.connect();
        session.setTimeout(0);
        return session;
    }

    protected void configureSession(Session session, Properties config) {
        session.setConfig(config);
    }

    private void getAuthDetails(Questioner q) {
        while (true) {
            if (this.host == null) {
                this.host = q.questionVisible("host:", "localhost");
            }
            if (this.host == null || this.host.length() == 0) continue;
            if (this.host.indexOf(58) != -1) {
                String portString = this.host.substring(this.host.indexOf(58) + 1);
                try {
                    this.port = Integer.parseInt(portString);
                }
                catch (NumberFormatException eee) {
                    q.showMessage("Could not parse port : " + portString);
                    continue;
                }
                this.host = this.host.substring(0, this.host.indexOf(58));
            }
            if (this.user == null) {
                this.user = q.questionVisible("user:", System.getProperty("user.name").toLowerCase());
            }
            if (this.host != null && this.host.length() != 0) break;
        }
    }

    @Override
    public String getName() {
        return "ConnectRunnable";
    }

    @Override
    public int read(byte[] buf, int offset, int length) throws IOException {
        return this.in.read(buf, offset, length);
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.out.write(bytes);
        this.out.flush();
    }
}

