/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.vacuum.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.common.ui.SystemStatusPanel;
import org.lsst.ccs.subsystem.common.ui.TextFieldX;
import org.lsst.ccs.subsystem.common.ui.UiConstants;
import org.lsst.ccs.subsystem.common.ui.UiUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.vacuum.constants.DeviceState;
import org.lsst.ccs.subsystem.vacuum.data.VacSysState;

public class PumpCartControlPanel
extends JPanel
implements UiUtilities.ActionHandler,
CommandSender.ReplyHandler {
    static final Font FONT = new Font("Tahoma", 1, 12);
    private static final String CMND_GET_STATE = "getVacuumState";
    private static final int SWTP_PUMP = 0;
    private static final int SWTP_VALVE = 1;
    private static final String DSAB_TEXT = "DSAB";
    private static final Map<DeviceState, Color> deviceStateColors = new HashMap<DeviceState, Color>();
    private final CommandSender sender;
    private final UiUtilities uiUtils;
    private SystemStatusPanel sysStatPanel;
    private VacSysState last_vs;
    private final JPanel headPanel = new JPanel();
    private static final Logger LOG;
    private JRadioButton pumpOn = new JRadioButton();
    private JRadioButton pumpOff = new JRadioButton();
    private JRadioButton ventOn = new JRadioButton();
    private JRadioButton ventOff = new JRadioButton();
    private int pulseVentTime = 1;
    private JButton pulseVent = new JButton();
    private TextFieldX pulseVentPeriodTextField;
    private final JLabel pulseVentPeriodLabel = new JLabel("Pulse Period: ");
    private final JLabel pulseVentPeriodUnitsLabel = new JLabel("            sec");
    private int pulsePumpTime = 1;
    private JButton pulsePump = new JButton();
    private double minPumpPressure = 0.0;
    private TextFieldX pulsePumpPeriodTextField;
    private final JLabel pulsePumpPeriodLabel = new JLabel("Pulse Period: ");
    private final JLabel pulsePumpPeriodUnitsLabel = new JLabel("            sec");
    private double maxVentPressure = 770.0;
    private TextFieldX maxVentPressureTextField;
    private final JLabel maxVentPressureLabel = new JLabel("Max Vent P: ");
    private final JLabel maxVentPressureUnitsLabel = new JLabel("               Torr");
    private TextFieldX minPumpPressureTextField;
    private final JLabel minPumpPressureLabel = new JLabel("Min Pump P: ");
    private final JLabel minPumpPressureUnitsLabel = new JLabel("               Torr");
    private JButton abortPump = new JButton();
    private JButton abortVent = new JButton();
    private TextFieldX cryoPrTextField;
    private TextFieldX cryoTurboPrTextField;
    private TextFieldX cryoFlinePrTextField;
    private TextFieldX hxPrTextField;
    private TextFieldX hxTurboPrTextField;
    private TextFieldX hxFlinePrTextField;
    private TextFieldX pcPrTextField;
    private TextFieldX pcPrTextField2;
    private TextFieldX refPrTextField;
    private TextFieldX ventingTextField;
    private TextFieldX cyclingTextField;
    private TextFieldX cryoValveTextField;
    private TextFieldX hxValveTextField;
    private TextFieldX prRefSrcTextField;
    private JPanel pumpCartPanel;
    private ButtonGroup pgroup = new ButtonGroup();
    private ButtonGroup vgroup = new ButtonGroup();
    private volatile VacSysState vacState;
    private final Object vacStateLock = new Object();
    private static final long serialVersionUID = 1L;

    public PumpCartControlPanel(CommandSender cons) {
        this.uiUtils = new UiUtilities((UiUtilities.ActionHandler)this);
        this.sender = cons;
        this.initComponents();
        new DisablePanel().run();
    }

    public void initPanel() {
        this.sender.sendCommand(true, null, CMND_GET_STATE, new Object[0]);
    }

    public void onCommandReply(Object reply, String path, String command, Object[] args) {
        this.updatePanel((VacSysState)reply);
    }

    public void onCommandReject(String path, String command, Object[] args) {
        if (!command.equals(CMND_GET_STATE)) {
            this.updatePanel(this.vacState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePanel(VacSysState vss) {
        Object object = this.vacStateLock;
        synchronized (object) {
            this.vacState = vss;
            SwingUtilities.invokeLater(new UpdateVacState(vss));
        }
    }

    public void disablePanel() {
        SwingUtilities.invokeLater(new DisablePanel());
    }

    private void initComponents() {
        this.sysStatPanel = new SystemStatusPanel(this.sender, "MonitorControl", true);
        this.pumpOn = this.uiUtils.newRadioButton("On", "PON", true);
        this.pumpOff = this.uiUtils.newRadioButton("Off", "POFF");
        this.pgroup.add(this.pumpOn);
        this.pgroup.add(this.pumpOff);
        this.ventOn = this.uiUtils.newRadioButton("On", "VON", true);
        this.ventOff = this.uiUtils.newRadioButton("Off", "VOFF");
        this.vgroup.add(this.ventOn);
        this.vgroup.add(this.ventOff);
        String prValsSpace = "awaiting update";
        this.cryoPrTextField = this.uiUtils.newTextFieldX(prValsSpace, "CRPTF", 0, true);
        this.cryoTurboPrTextField = this.uiUtils.newTextFieldX(prValsSpace, "CRTPTF", 0, true);
        this.cryoFlinePrTextField = this.uiUtils.newTextFieldX(prValsSpace, "CRFPTF", 0, true);
        this.hxPrTextField = this.uiUtils.newTextFieldX(prValsSpace, "CPTF", 0, true);
        this.hxTurboPrTextField = this.uiUtils.newTextFieldX(prValsSpace, "HXTPTF", 0, true);
        this.hxFlinePrTextField = this.uiUtils.newTextFieldX(prValsSpace, "HXFPTF", 0, true);
        this.pcPrTextField = this.uiUtils.newTextFieldX(prValsSpace, "PCCFPF", 0, true);
        this.pcPrTextField2 = this.uiUtils.newTextFieldX(prValsSpace, "PCC2FPF", 0, true);
        this.refPrTextField = this.uiUtils.newTextFieldX(prValsSpace, "REFCFPF", 0, true);
        this.ventingTextField = this.uiUtils.newTextFieldX("------------", "VTF", 0, true);
        this.cyclingTextField = this.uiUtils.newTextFieldX("------------", "CTF", 0, true);
        this.cryoValveTextField = this.uiUtils.newTextFieldX("--------------", "CVTF", 0, true);
        this.hxValveTextField = this.uiUtils.newTextFieldX("--------------", "HVTF", 0, true);
        this.prRefSrcTextField = this.uiUtils.newTextFieldX("------------------------", "HVTF", 0, true);
        this.abortVent = this.uiUtils.newButton("Abort Venting", "abortVent", true);
        this.pulseVent = this.uiUtils.newButton("Pulse Venting", "pulseVent", true);
        this.pulseVentPeriodLabel.setFont(FONT);
        this.pulseVentPeriodTextField = this.uiUtils.newTextFieldX(String.format("%04d", this.pulseVentTime), "VP", 0, true);
        this.abortPump = this.uiUtils.newButton("Abort Pumping", "abortPump", true);
        this.pulsePump = this.uiUtils.newButton("Pulse Pumping", "pulsePump", true);
        this.pulsePumpPeriodLabel.setFont(FONT);
        this.pulsePumpPeriodTextField = this.uiUtils.newTextFieldX(String.format("%04d", this.pulsePumpTime), "PP", 0, true);
        this.maxVentPressureLabel.setFont(FONT);
        this.maxVentPressureTextField = this.uiUtils.newTextFieldX(String.format("%06.2f", this.maxVentPressure), "MXV", 0, true);
        this.minPumpPressureLabel.setFont(FONT);
        this.minPumpPressureTextField = this.uiUtils.newTextFieldX(String.format("%06.2f", this.minPumpPressure), "MNP", 0, true);
        this.pulsePumpPeriodUnitsLabel.setFont(FONT);
        this.headPanel.setLayout(new GridBagLayout());
        this.pumpCartPanel = UiUtilities.newBorderedPanel((String)"Pump Cart");
        GridBagConstraints gbpc = new GridBagConstraints();
        gbpc.anchor = 17;
        gbpc.insets = new Insets(0, 0, 4, 4);
        gbpc.gridx = 0;
        gbpc.gridy = 0;
        gbpc.anchor = 17;
        gbpc.insets.left = 5;
        this.pumpCartPanel.add((Component)UiUtilities.newLabel((String)"Cryo P: ", (int)0), gbpc);
        ++gbpc.gridx;
        this.pumpCartPanel.add((Component)this.cryoPrTextField, gbpc);
        ++gbpc.gridx;
        this.pumpCartPanel.add((Component)UiUtilities.newLabel((String)"Hx P: ", (int)0), gbpc);
        ++gbpc.gridx;
        this.pumpCartPanel.add((Component)this.hxPrTextField, gbpc);
        ++gbpc.gridy;
        gbpc.gridx = 0;
        this.pumpCartPanel.add((Component)UiUtilities.newLabel((String)"Cryo Turbo P: ", (int)0), gbpc);
        ++gbpc.gridx;
        this.pumpCartPanel.add((Component)this.cryoTurboPrTextField, gbpc);
        ++gbpc.gridx;
        this.pumpCartPanel.add((Component)UiUtilities.newLabel((String)"Hx Turbo P: ", (int)0), gbpc);
        ++gbpc.gridx;
        this.pumpCartPanel.add((Component)this.hxTurboPrTextField, gbpc);
        ++gbpc.gridy;
        gbpc.gridx = 0;
        this.pumpCartPanel.add((Component)UiUtilities.newLabel((String)"Cryo Foreline P: ", (int)0), gbpc);
        ++gbpc.gridx;
        this.pumpCartPanel.add((Component)this.cryoFlinePrTextField, gbpc);
        ++gbpc.gridx;
        this.pumpCartPanel.add((Component)UiUtilities.newLabel((String)"Hx Foreline P: ", (int)0), gbpc);
        ++gbpc.gridx;
        this.pumpCartPanel.add((Component)this.hxFlinePrTextField, gbpc);
        ++gbpc.gridy;
        gbpc.gridx = 0;
        this.pumpCartPanel.add((Component)UiUtilities.newLabel((String)"Pump Cart Pressure: ", (int)0), gbpc);
        ++gbpc.gridx;
        this.pumpCartPanel.add((Component)this.pcPrTextField, gbpc);
        ++gbpc.gridx;
        this.pumpCartPanel.add((Component)UiUtilities.newLabel((String)"Pump Cart Pressure: ", (int)0), gbpc);
        ++gbpc.gridx;
        this.pumpCartPanel.add((Component)this.pcPrTextField2, gbpc);
        ++gbpc.gridx;
        ++gbpc.gridy;
        gbpc.gridx = 0;
        this.pumpCartPanel.add((Component)UiUtilities.newLabel((String)" ", (int)0), gbpc);
        gbpc.gridx = 0;
        this.pumpCartPanel.add((Component)UiUtilities.newLabel((String)"Cryo Foreline Valve: ", (int)0), gbpc);
        ++gbpc.gridx;
        this.pumpCartPanel.add((Component)this.cryoValveTextField, gbpc);
        ++gbpc.gridx;
        this.pumpCartPanel.add((Component)UiUtilities.newLabel((String)"HX Foreline Valve: ", (int)0), gbpc);
        ++gbpc.gridx;
        this.pumpCartPanel.add((Component)this.hxValveTextField, gbpc);
        ++gbpc.gridy;
        gbpc.gridx -= 2;
        this.pumpCartPanel.add((Component)UiUtilities.newLabel((String)" ", (int)0), gbpc);
        ++gbpc.gridy;
        this.pumpCartPanel.add((Component)UiUtilities.newLabel((String)"Pump Cart Control", (int)0), gbpc);
        ++gbpc.gridy;
        gbpc.gridx = 0;
        this.pumpCartPanel.add((Component)UiUtilities.newLabel((String)"Pump State: ", (int)0), gbpc);
        ++gbpc.gridx;
        this.pumpCartPanel.add((Component)this.cyclingTextField, gbpc);
        ++gbpc.gridx;
        this.pumpCartPanel.add((Component)this.pumpOn, gbpc);
        ++gbpc.gridx;
        this.pumpCartPanel.add((Component)this.pumpOff, gbpc);
        gbpc.gridx = 0;
        ++gbpc.gridy;
        this.pumpCartPanel.add((Component)UiUtilities.newLabel((String)"Pulse pump: ", (int)0), gbpc);
        ++gbpc.gridx;
        this.pumpCartPanel.add((Component)this.pulsePumpPeriodTextField, gbpc);
        this.pumpCartPanel.add((Component)this.pulsePumpPeriodUnitsLabel, gbpc);
        ++gbpc.gridx;
        this.pumpCartPanel.add((Component)this.pulsePump, gbpc);
        ++gbpc.gridx;
        this.pumpCartPanel.add((Component)this.abortPump, gbpc);
        ++gbpc.gridy;
        this.pumpCartPanel.add((Component)UiUtilities.newLabel((String)" ", (int)0), gbpc);
        ++gbpc.gridy;
        gbpc.gridx = 0;
        this.pumpCartPanel.add((Component)UiUtilities.newLabel((String)"Venting State: ", (int)0), gbpc);
        ++gbpc.gridx;
        this.pumpCartPanel.add((Component)this.ventingTextField, gbpc);
        ++gbpc.gridx;
        this.pumpCartPanel.add((Component)this.ventOn, gbpc);
        ++gbpc.gridx;
        this.pumpCartPanel.add((Component)this.ventOff, gbpc);
        gbpc.gridx = 0;
        ++gbpc.gridy;
        this.pumpCartPanel.add((Component)UiUtilities.newLabel((String)"Pulse vent: ", (int)0), gbpc);
        ++gbpc.gridx;
        this.pumpCartPanel.add((Component)this.pulseVentPeriodTextField, gbpc);
        this.pumpCartPanel.add((Component)this.pulseVentPeriodUnitsLabel, gbpc);
        ++gbpc.gridx;
        this.pumpCartPanel.add((Component)this.pulseVent, gbpc);
        ++gbpc.gridx;
        this.pumpCartPanel.add((Component)this.abortVent, gbpc);
        gbpc.gridx = 0;
        ++gbpc.gridy;
        this.pumpCartPanel.add((Component)UiUtilities.newLabel((String)" ", (int)0), gbpc);
        ++gbpc.gridy;
        this.pumpCartPanel.add((Component)UiUtilities.newLabel((String)"Press Ref Src:", (int)0), gbpc);
        ++gbpc.gridx;
        this.pumpCartPanel.add((Component)this.prRefSrcTextField, gbpc);
        ++gbpc.gridx;
        this.pumpCartPanel.add((Component)UiUtilities.newLabel((String)"Ref. Pressure: ", (int)0), gbpc);
        ++gbpc.gridx;
        this.pumpCartPanel.add((Component)this.refPrTextField, gbpc);
        ++gbpc.gridy;
        gbpc.gridx = 0;
        this.pumpCartPanel.add((Component)UiUtilities.newLabel((String)"Max Vent Pressure: ", (int)0), gbpc);
        ++gbpc.gridx;
        this.pumpCartPanel.add((Component)this.maxVentPressureTextField, gbpc);
        this.pumpCartPanel.add((Component)this.maxVentPressureUnitsLabel, gbpc);
        ++gbpc.gridx;
        this.pumpCartPanel.add((Component)UiUtilities.newLabel((String)"Min Pump Pressure: ", (int)0), gbpc);
        ++gbpc.gridx;
        this.pumpCartPanel.add((Component)this.minPumpPressureTextField, gbpc);
        this.pumpCartPanel.add((Component)this.minPumpPressureUnitsLabel, gbpc);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbm = new GridBagConstraints();
        gbm.insets = new Insets(6, 0, 6, 0);
        gbm.anchor = 11;
        gbm.gridx = 0;
        gbm.gridy = 0;
        this.add((Component)this.pumpCartPanel, gbm);
    }

    public void handleRadioButton(String name) {
        LOG.log(Level.INFO, "button name = " + name);
        LOG.log(Level.INFO, "last venting switch state" + this.last_vs.getPumpCartVentingSwitchState());
        if (name.charAt(0) == 'P') {
            if (name.contains("OFF")) {
                this.sender.sendCommand("PumpCart", "pumpOn", new Object[]{false});
            } else if (this.pumpOn.isEnabled()) {
                this.sender.sendCommand("PumpCart", "pulsePump", new Object[]{-1});
            } else {
                this.pumpOn.setEnabled(true);
                this.pgroup.clearSelection();
                if (this.last_vs != null) {
                    this.pumpOn.setSelected(this.last_vs.getPumpCartPumpingSwitchState());
                    this.pumpOff.setSelected(!this.last_vs.getPumpCartPumpingSwitchState());
                    LOG.log(Level.INFO, "pump switch state change rejected. State remains at " + this.last_vs.getPumpCartPumpingSwitchState());
                }
            }
        } else if (name.charAt(0) == 'V') {
            if (name.contains("OFF")) {
                this.sender.sendCommand("PumpCart", "openVentValve", new Object[]{false});
            } else if (this.ventOn.isEnabled()) {
                this.sender.sendCommand("PumpCart", "pulseVentValve", new Object[]{-1});
            } else {
                this.ventOn.setEnabled(true);
                this.vgroup.clearSelection();
                if (this.last_vs != null) {
                    this.ventOn.setSelected(this.last_vs.getPumpCartVentingSwitchState());
                    this.ventOff.setSelected(!this.last_vs.getPumpCartVentingSwitchState());
                    LOG.log(Level.INFO, "vent switch state change rejected. State remains at " + this.last_vs.getPumpCartVentingSwitchState());
                }
            }
        }
    }

    public void handleButton(String name) {
        LOG.severe("button name = " + name);
        if (name.contains("pulseVent")) {
            this.sender.sendCommand("PumpCart", "pulseVentValve", new Object[]{this.pulseVentTime});
        } else if (name.contains("pulsePump")) {
            this.sender.sendCommand("PumpCart", "pulsePump", new Object[]{this.pulsePumpTime});
        } else if (name.contains("abortVent")) {
            this.sender.sendCommand("PumpCart", "abortVent", new Object[0]);
        } else if (name.contains("abortPump")) {
            this.sender.sendCommand("PumpCart", "abortPump", new Object[0]);
        }
    }

    public void handleTextFieldX(String name, Object value) {
        if (name.contains("VP")) {
            try {
                this.pulseVentTime = Integer.decode((String)value);
            }
            catch (NumberFormatException nfe) {
                this.pulseVentTime = 0;
            }
            this.pulseVentPeriodTextField.update((Object)String.format("%d", this.pulseVentTime), true);
        } else if (name.contains("PP")) {
            try {
                this.pulsePumpTime = Integer.decode((String)value);
            }
            catch (NumberFormatException nfe) {
                this.pulsePumpTime = 0;
            }
            this.pulsePumpPeriodTextField.update((Object)String.format("%d", this.pulsePumpTime), true);
        } else if (name.contains("MXV")) {
            try {
                this.maxVentPressure = Double.parseDouble((String)value);
                this.sender.sendCommand("PumpCart", "setMaxVentPressure", new Object[]{this.maxVentPressure});
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.maxVentPressureTextField.update((Object)String.format("%6.2f", this.maxVentPressure), true);
        } else if (name.contains("MNP")) {
            try {
                this.minPumpPressure = Double.parseDouble((String)value);
                this.sender.sendCommand("PumpCart", "setMinPumpPressure", new Object[]{this.minPumpPressure});
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.minPumpPressureTextField.update((Object)String.format("%6.2f", this.minPumpPressure), true);
        }
    }

    static {
        deviceStateColors.put(DeviceState.AUTOTUN, Color.BLACK);
        deviceStateColors.put(DeviceState.BRAKING, UiConstants.YELLOW);
        deviceStateColors.put(DeviceState.FAILED, UiConstants.RED);
        deviceStateColors.put(DeviceState.NORMAL, UiConstants.GREEN);
        deviceStateColors.put(DeviceState.STARTNG, UiConstants.YELLOW);
        deviceStateColors.put(DeviceState.STOPPED, Color.BLACK);
        deviceStateColors.put(DeviceState.WAITING, UiConstants.YELLOW);
        deviceStateColors.put(DeviceState.OPEN, UiConstants.GREEN);
        deviceStateColors.put(DeviceState.SHUT, Color.BLACK);
        deviceStateColors.put(DeviceState.TRANSIT, UiConstants.YELLOW);
        deviceStateColors.put(DeviceState.ERROR, UiConstants.RED);
        deviceStateColors.put(DeviceState.OFFLINE, UiConstants.BLUE);
        LOG = Logger.getLogger(PumpCartControlPanel.class.getName());
    }

    class DisablePanel
    implements Runnable {
        DisablePanel() {
        }

        @Override
        public void run() {
        }
    }

    class UpdateVacState
    implements Runnable {
        private final VacSysState vs;

        UpdateVacState(VacSysState vs) {
            this.vs = vs;
            PumpCartControlPanel.this.last_vs = this.vs;
        }

        @Override
        public void run() {
            PumpCartControlPanel.this.sysStatPanel.updatePanel(this.vs.getTickMillis());
            PumpCartControlPanel.this.cryoPrTextField.update((Object)String.format("%7.3g", this.vs.getCryoPress()), true);
            PumpCartControlPanel.this.cryoTurboPrTextField.update((Object)String.format("%7.3g", this.vs.getCryoTurboPress()), true);
            PumpCartControlPanel.this.cryoFlinePrTextField.update((Object)String.format("%7.3g", this.vs.getCryoFlinePress()), true);
            PumpCartControlPanel.this.hxPrTextField.update((Object)String.format("%7.3g", this.vs.getHXPress()), true);
            PumpCartControlPanel.this.hxTurboPrTextField.update((Object)String.format("%7.3g", this.vs.getHXTurboPress()), true);
            PumpCartControlPanel.this.hxFlinePrTextField.update((Object)String.format("%7.3g", this.vs.getHXFlinePress()), true);
            PumpCartControlPanel.this.pcPrTextField.update((Object)String.format("%7.3g", this.vs.getPCPress()), true);
            PumpCartControlPanel.this.pcPrTextField2.update((Object)String.format("%7.3g", this.vs.getPCPress()), true);
            PumpCartControlPanel.this.refPrTextField.update((Object)String.format("%7.3g", this.vs.getPCTargetPressure()), true);
            Color color = Color.BLACK;
            if (Double.isNaN(this.vs.getPCPress())) {
                PumpCartControlPanel.this.ventingTextField.update((Object)"Offline", true);
                PumpCartControlPanel.this.cyclingTextField.update((Object)"Offline", true);
                color = UiConstants.YELLOW;
            } else {
                PumpCartControlPanel.this.ventingTextField.update((Object)(this.vs.getVentingStatus() == 0.0 ? "Off" : "Active"), true);
                PumpCartControlPanel.this.cyclingTextField.update((Object)(this.vs.getCyclingStatus() == 0.0 ? "Off" : "Active"), true);
            }
            PumpCartControlPanel.this.ventingTextField.setForeground(color);
            PumpCartControlPanel.this.cyclingTextField.setForeground(color);
            PumpCartControlPanel.this.cryoValveTextField.update((Object)this.vs.getCryoForelineValveStatus(), true);
            PumpCartControlPanel.this.hxValveTextField.update((Object)this.vs.getHXForelineValveStatus(), true);
            PumpCartControlPanel.this.prRefSrcTextField.update((Object)this.vs.getPCTargetPressureSrc(), true);
            PumpCartControlPanel.this.maxVentPressureTextField.update((Object)String.format("%6.2f", PumpCartControlPanel.this.maxVentPressure), true);
            PumpCartControlPanel.this.minPumpPressureTextField.update((Object)String.format("%6.2f", PumpCartControlPanel.this.minPumpPressure), true);
            PumpCartControlPanel.this.pgroup.clearSelection();
            PumpCartControlPanel.this.pumpOn.setSelected(this.vs.getPumpCartPumpingSwitchState());
            PumpCartControlPanel.this.pumpOff.setSelected(!this.vs.getPumpCartPumpingSwitchState());
            LOG.log(Level.FINE, "pump switch state = " + this.vs.getPumpCartPumpingSwitchState());
            PumpCartControlPanel.this.pumpOn.setForeground(color);
            PumpCartControlPanel.this.pumpOff.setForeground(color);
            PumpCartControlPanel.this.vgroup.clearSelection();
            PumpCartControlPanel.this.ventOn.setSelected(this.vs.getPumpCartVentingSwitchState());
            PumpCartControlPanel.this.ventOff.setSelected(!this.vs.getPumpCartVentingSwitchState());
            LOG.log(Level.FINE, "vent switch state = " + this.vs.getPumpCartVentingSwitchState());
            PumpCartControlPanel.this.ventOn.setForeground(color);
            PumpCartControlPanel.this.ventOff.setForeground(color);
            PumpCartControlPanel.this.pulseVent.setForeground(color);
            PumpCartControlPanel.this.pulsePump.setForeground(color);
        }
    }
}

