/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending;

import java.awt.Color;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Function;

public enum Meta {
    RANGE(null, in -> {
        int n = in[0].length;
        double[] errMin = new double[n];
        double[] errMax = new double[n];
        for (int i = 0; i < n; ++i) {
            errMin[i] = Math.max(in[0][i] - in[1][i], 0.0);
            errMax[i] = Math.max(in[2][i] - in[0][i], 0.0);
        }
        return new double[][]{errMin, errMax};
    }, "min", "max"),
    RMS(null, in -> new double[][]{in[1], in[1]}, "rms"),
    ALARM(Color.RED, null, "alarmLow", "alarmHigh"),
    WARNING(Color.GREEN, null, "warningLow", "warningHigh");

    private static final EnumSet<Meta> onPointSet;
    private static final EnumSet<Meta> offPointSet;
    private final Color color;
    private final List<String> keys;
    private final Function<double[][], double[][]> computeBars;

    private Meta(Color color, Function<double[][], double[][]> computeBars, String ... keys) {
        this.color = color;
        this.computeBars = computeBars;
        this.keys = Collections.unmodifiableList(Arrays.asList(keys));
    }

    public static EnumSet<Meta> getOnPointSet() {
        return onPointSet;
    }

    public static EnumSet<Meta> getOffPointSet() {
        return offPointSet;
    }

    public boolean isOnPoint() {
        return onPointSet.contains((Object)this);
    }

    public Color getColor() {
        return this.color;
    }

    public int size() {
        return this.keys.size();
    }

    public List<String> getKeys() {
        return this.keys;
    }

    public double[][] getBars(double[][] in) {
        if (in == null || this.computeBars == null) {
            return new double[2][];
        }
        for (double[] data : in) {
            if (data != null) continue;
            return new double[2][];
        }
        return this.computeBars.apply(in);
    }

    static {
        onPointSet = EnumSet.of(RANGE, RMS);
        offPointSet = EnumSet.of(ALARM, WARNING);
    }
}

