/*
 * Decompiled with CFR 0.152.
 */
package com.wittams.gritty;

import com.wittams.gritty.Style;
import com.wittams.gritty.StyledRunConsumer;
import java.awt.Point;
import org.apache.log4j.Logger;

public class SelectionRunConsumer
implements StyledRunConsumer {
    private static final Logger logger = Logger.getLogger(SelectionRunConsumer.class);
    private final StringBuffer selection;
    private final Point begin;
    private final Point end;
    boolean first = true;

    public SelectionRunConsumer(StringBuffer selection, Point begin, Point end) {
        this.selection = selection;
        this.end = end;
        this.begin = begin;
    }

    @Override
    public void consumeRun(int x, int y, Style style, char[] buf, int start, int len) {
        int startPos = start;
        int extent = len;
        if (y == this.end.y) {
            extent = Math.min(this.end.x - x, extent);
        }
        if (y == this.begin.y) {
            int xAdj = Math.max(0, this.begin.x - x);
            startPos += xAdj;
            if ((extent -= xAdj) < 0) {
                return;
            }
        }
        if (extent < 0) {
            return;
        }
        if (len > 0) {
            if (!this.first && x == 0) {
                this.selection.append('\n');
            }
            this.first = false;
            if (startPos < 0) {
                logger.error((Object)"Attempt to copy to selection from before start of buffer");
            } else if (startPos + extent >= buf.length) {
                logger.error((Object)"Attempt to copy to selection from after end of buffer");
            } else {
                this.selection.append(buf, startPos, extent);
            }
        }
    }
}

