/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.commandbrowser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.lsst.ccs.command.DictionaryArgument;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.Options;
import org.lsst.ccs.command.StringTokenizer;
import org.lsst.ccs.command.SupportedOption;
import org.lsst.ccs.command.TokenizedCommand;
import org.lsst.ccs.gconsole.plugins.commandbrowser.AgentPanel;
import org.lsst.ccs.gconsole.plugins.commandbrowser.CommandListPanel;
import org.lsst.ccs.gconsole.plugins.commandbrowser.HintTextField;
import org.lsst.ccs.services.AgentCommandDictionaryService;

public final class ArgInputPanel
extends JPanel
implements ListSelectionListener {
    private final AgentPanel aPanel;
    private DictionaryCommand command;
    private ArgInput[] argGetters;
    private final JPanel formPane;
    private final JEditorPane commandDesc;
    private JButton sendCmdButton;
    private final Map<String, String[]> history = new LinkedHashMap<String, String[]>(4, 0.8f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, String[]> eldest) {
            return this.size() > 50;
        }
    };
    private boolean valuesValid;
    private final String OPTIONS_TYPE = "opts";

    public ArgInputPanel(AgentPanel agentPanel) {
        this.aPanel = agentPanel;
        this.setLayout(new BorderLayout());
        this.commandDesc = new JEditorPane();
        this.add((Component)new JScrollPane(this.commandDesc), "Center");
        this.commandDesc.setBackground(new Color(237, 236, 235));
        this.commandDesc.setEditable(false);
        this.commandDesc.setContentType("text/html");
        this.commandDesc.setText("      ");
        this.formPane = new JPanel();
        this.formPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
    }

    void setCommandButton(JButton button) {
        this.sendCmdButton = button;
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        CommandListPanel commandListPanel = (CommandListPanel)lse.getSource();
        this.command = (DictionaryCommand)commandListPanel.getSelectedValue();
        this.clear();
        if (this.command != null) {
            this.fill();
        }
        boolean enabled = commandListPanel.isVisibleCommandSelected();
        this.setEnabled(enabled);
        if (enabled) {
            this.add((Component)this.formPane, "South");
            this.updateValidity(true);
        } else {
            this.remove(this.formPane);
            this.sendCmdButton.setEnabled(false);
        }
    }

    public String getValuesAsString() {
        return String.join((CharSequence)" ", this.retrieveValues());
    }

    private List<String> retrieveValues() {
        int n = this.argGetters.length;
        if (n == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> out = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            String s = this.argGetters[i].get();
            String type = this.argGetters[i].getType();
            if ("opts".equals(type)) {
                if (s.isEmpty()) continue;
                out.add(s);
                continue;
            }
            boolean isCollection = type.equals("List") || type.equals("Set") || type.equals("Map");
            List tt = StringTokenizer.tokenize((String)s);
            if (this.command.isVarArgs() && i == n - 1) {
                if (tt.isEmpty()) continue;
                out.add(s);
                continue;
            }
            if (tt.isEmpty()) {
                if (isCollection) {
                    out.add("[]");
                    continue;
                }
                out.add("\"" + s + "\"");
                continue;
            }
            if (tt.size() == 1) {
                StringTokenizer.Token t = (StringTokenizer.Token)tt.get(0);
                String ts = t.getString();
                if (isCollection) {
                    if (ts.isEmpty()) {
                        out.add("[]");
                        continue;
                    }
                    if (ts.charAt(0) == '[') {
                        out.add(ts);
                        continue;
                    }
                    out.add("[" + ts + "]");
                    continue;
                }
                out.add(s);
                continue;
            }
            if (isCollection) {
                out.add("[" + s + "]");
                continue;
            }
            out.add("\"" + s + "\"");
        }
        if (this.command != null && out != null && !out.isEmpty()) {
            this.history.put(this.command.getCommandName(), out.toArray(new String[0]));
        }
        return out;
    }

    private void clear() {
        this.formPane.removeAll();
        this.commandDesc.setText("       ");
        this.valuesValid = false;
        this.sendCmdButton.setEnabled(this.valuesValid);
    }

    private void fill() {
        int nArgs = this.command.getArguments().length;
        List opts = this.command.getSupportedOptions();
        boolean hasOptions = !opts.isEmpty();
        int nInputs = hasOptions ? nArgs + 1 : nArgs;
        this.formPane.setLayout(new GridLayout(nInputs, 2));
        this.argGetters = new ArgInput[nInputs];
        if (hasOptions) {
            String defOpt = this.aPanel.descriptor.isWithLock() && opts.stream().map(p -> p.getName()).anyMatch(s -> s.equals(AgentCommandDictionaryService.withLockOption.getName())) ? "-w" : "";
            this.argGetters[0] = new ArgInput(opts, defOpt);
            this.formPane.add(this.argGetters[0].getLabel());
            this.formPane.add(this.argGetters[0].getEditor());
        }
        for (int i = 0; i < nArgs; ++i) {
            DictionaryArgument da = this.command.getArguments()[i];
            boolean isVararg = this.command.isVarArgs() && i == nArgs - 1;
            String defValue = this.getDefaultValueOfArgument(da);
            if (defValue == null && isVararg) {
                defValue = "";
            }
            ArgInput input = new ArgInput(da, defValue, isVararg);
            this.argGetters[hasOptions ? i + 1 : i] = input;
            this.formPane.add(input.getLabel());
            this.formPane.add(input.getEditor());
        }
        String[] hist = this.history.get(this.command.getCommandName());
        if (hist != null && hist.length <= nInputs) {
            for (int ii = 0; ii < hist.length; ++ii) {
                if (hist[ii] == null) continue;
                this.argGetters[ii].set(hist[ii]);
            }
        }
        StringBuilder sb = new StringBuilder("<html>");
        sb.append(this.command.getType()).append(". Level: ").append(this.command.getLevel());
        sb.append("<h3>").append(this.command.getDescription()).append("</h3>");
        this.commandDesc.setText(sb.toString());
        this.updateValidity(true);
        this.setEnabled(this.isEnabled());
        this.repaint();
        this.validate();
    }

    private void updateValidity(boolean argValid) {
        if (this.valuesValid == argValid) {
            return;
        }
        if (argValid) {
            for (ArgInput argInput : this.argGetters) {
                if (argInput.isValueValid()) continue;
                return;
            }
            this.valuesValid = true;
        } else {
            this.valuesValid = false;
        }
        this.sendCmdButton.setEnabled(this.valuesValid);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.add((Component)this.formPane, "South");
        } else {
            this.remove(this.formPane);
        }
    }

    private String getDefaultValueOfArgument(DictionaryArgument da) {
        String out = da.getDefaultValue();
        if (out != null) {
            switch (out) {
                case "***NOT_SET_INITIAL_VALUE***": {
                    return null;
                }
                case "***NULL_VALUE_FOR_COMMAND_ARGUMENT***": {
                    return "null";
                }
            }
        }
        return out;
    }

    private static final class OptionsEditor
    extends JButton {
        private final SupportedOption[] supportedOptions;
        private final boolean[] options;

        OptionsEditor(List<SupportedOption> opt, String value) {
            int n = opt.size();
            this.supportedOptions = opt.toArray(new SupportedOption[n]);
            this.options = new boolean[n];
            this.set(value);
            this.addActionListener(e -> this.edit());
        }

        void set(String value) {
            TokenizedCommand tc = new TokenizedCommand("command " + value);
            Options opt = tc.getOptions();
            Set optSet = opt.getOptions();
            StringBuilder sb = new StringBuilder("-");
            for (int i = 0; i < this.options.length; ++i) {
                SupportedOption so = this.supportedOptions[i];
                if (optSet.contains(so.getSingleLetterName()) || optSet.contains(so.getName())) {
                    sb.append(so.getSingleLetterName());
                    this.options[i] = true;
                    continue;
                }
                this.options[i] = false;
            }
            value = sb.length() == 1 ? "" : sb.toString();
            this.setText(value);
        }

        String get() {
            return this.getText();
        }

        private void edit() {
            int n = this.supportedOptions.length;
            ArrayList<JCheckBox> checkBoxList = new ArrayList<JCheckBox>(n);
            JPanel root = new JPanel(new GridLayout(n, 1, 10, 5));
            for (int i = 0; i < n; ++i) {
                SupportedOption so = this.supportedOptions[i];
                JCheckBox cb = new JCheckBox(so.getName());
                cb.setSelected(this.options[i]);
                cb.setToolTipText(so.getDescription());
                checkBoxList.add(cb);
                root.add(cb);
            }
            int out = JOptionPane.showOptionDialog(this, root, "Select options", 2, -1, null, null, null);
            if (out == 0) {
                StringBuilder sb = new StringBuilder("-");
                for (int i = 0; i < n; ++i) {
                    if (((JCheckBox)checkBoxList.get(i)).isSelected()) {
                        sb.append(this.supportedOptions[i].getSingleLetterName());
                        this.options[i] = true;
                        continue;
                    }
                    this.options[i] = false;
                }
                String value = sb.length() == 1 ? "" : sb.toString();
                this.setText(value);
            }
        }
    }

    private class ArgInput {
        private final DictionaryArgument da;
        private final boolean isVararg;
        private boolean valueValid;
        private final JComponent editor;
        private final JLabel label;

        ArgInput(DictionaryArgument da, String defValue, boolean isVararg) {
            this.da = da;
            this.isVararg = isVararg;
            this.label = new JLabel(da.getName());
            String tip = da.getDescription();
            if (tip != null && !tip.isEmpty()) {
                this.label.setToolTipText(tip);
            }
            List<String> allowedValues = da.getAllowedValues();
            String type = da.getSimpleType();
            if (allowedValues.isEmpty() && "boolean".equals(type)) {
                allowedValues = Arrays.asList("true", "false");
            }
            if (allowedValues.isEmpty()) {
                HintTextField htf = new HintTextField(isVararg ? type + "..." : type);
                if (defValue == null) {
                    this.valueValid = false;
                } else {
                    htf.setText(defValue);
                    this.valueValid = true;
                }
                htf.addCaretListener(e -> this.validateValue());
                this.editor = htf;
            } else {
                JComboBox<String> comboBox = new JComboBox<String>(allowedValues.toArray(new String[0]));
                defValue = da.getDefaultValue();
                if (defValue != null) {
                    comboBox.setSelectedItem(defValue);
                }
                this.valueValid = true;
                this.editor = comboBox;
            }
        }

        ArgInput(List<SupportedOption> options, String defValue) {
            this.da = null;
            this.isVararg = false;
            this.label = new JLabel("Options");
            this.label.setToolTipText("Click the button to enter options");
            this.valueValid = true;
            this.editor = new OptionsEditor(options, defValue);
        }

        void set(String value) {
            if (this.editor instanceof HintTextField) {
                ((HintTextField)this.editor).setText(value);
            } else if (this.editor instanceof JComboBox) {
                ((JComboBox)this.editor).setSelectedItem(value);
            } else if (this.editor instanceof OptionsEditor) {
                ((OptionsEditor)this.editor).set(value);
            }
            this.validateValue();
        }

        String get() {
            String out = this.editor instanceof HintTextField ? ((HintTextField)this.editor).getText() : (this.editor instanceof JComboBox ? ((JComboBox)this.editor).getSelectedItem().toString() : ((OptionsEditor)this.editor).get());
            return out;
        }

        String getType() {
            return this.da == null ? "opts" : this.da.getSimpleType();
        }

        boolean isValueValid() {
            return this.valueValid;
        }

        private void validateValue() {
            boolean nowValid = true;
            if (this.editor instanceof HintTextField) {
                String[] ss;
                String[] stringArray;
                String in = ((HintTextField)this.editor).getText();
                if (this.isVararg) {
                    stringArray = in.split("\\s+");
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = in;
                }
                block20: for (String s : ss = stringArray) {
                    switch (this.da.getSimpleType()) {
                        case "int": {
                            try {
                                Integer.decode(s);
                            }
                            catch (NumberFormatException x) {
                                nowValid = false;
                            }
                            continue block20;
                        }
                        case "long": {
                            try {
                                Long.decode(s);
                            }
                            catch (NumberFormatException x) {
                                nowValid = false;
                            }
                            continue block20;
                        }
                        case "float": {
                            try {
                                Float.parseFloat(s);
                            }
                            catch (NumberFormatException x) {
                                nowValid = false;
                            }
                            continue block20;
                        }
                        case "double": {
                            try {
                                Double.parseDouble(s);
                                continue block20;
                            }
                            catch (NumberFormatException x) {
                                nowValid = false;
                            }
                        }
                    }
                }
            }
            if (nowValid != this.valueValid) {
                this.valueValid = nowValid;
                ArgInputPanel.this.updateValidity(this.valueValid);
            }
        }

        JComponent getEditor() {
            return this.editor;
        }

        JLabel getLabel() {
            return this.label;
        }
    }
}

