/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.pdf.examples;

import hep.aida.IAnalysisFactory;
import hep.aida.IBaseHistogram;
import hep.aida.ICloud1D;
import hep.aida.IEvaluator;
import hep.aida.IFitFactory;
import hep.aida.IFunction;
import hep.aida.IFunctionFactory;
import hep.aida.IHistogram1D;
import hep.aida.IHistogramFactory;
import hep.aida.IPlotter;
import hep.aida.ITree;
import hep.aida.ITreeFactory;
import hep.aida.ITuple;
import hep.aida.ITupleFactory;
import hep.aida.ref.histogram.HistUtils;
import hep.aida.ref.pdf.Dependent;
import hep.aida.ref.pdf.Function;
import hep.aida.ref.pdf.FunctionMcStudy;
import hep.aida.ref.pdf.Gaussian;
import hep.aida.ref.pdf.PdfFitter;

public class McStudyUnbinnedGaussianFit {
    public static void main(String[] args) {
        IAnalysisFactory analysisFactory = IAnalysisFactory.create();
        ITreeFactory treeFactory = analysisFactory.createTreeFactory();
        ITree tree = treeFactory.create();
        IPlotter plotter = analysisFactory.createPlotterFactory().create("Plotter");
        ITupleFactory tupleFactory = analysisFactory.createTupleFactory(tree);
        IHistogramFactory histogramFactory = analysisFactory.createHistogramFactory(tree);
        IFunctionFactory functionFactory = analysisFactory.createFunctionFactory(tree);
        IFitFactory fitFactory = analysisFactory.createFitFactory();
        Dependent x = new Dependent("x", -3.0, 8.0);
        Gaussian g = new Gaussian("gauss", x);
        g.setParameter("mean", 3.0);
        g.setParameter("sigma", 0.5);
        ITuple t = FunctionMcStudy.generateTuple(g, 10000);
        ICloud1D c = histogramFactory.createCloud1D("c");
        IHistogram1D h = histogramFactory.createHistogram1D("h", 100, -3.0, 8.0);
        IEvaluator ev = tupleFactory.createEvaluator("x");
        t.project(c, ev);
        c.fillHistogram(h);
        h.scale(1.0 / HistUtils.histogramNormalization(h));
        plotter.region(0).plot((IBaseHistogram)h);
        PdfFitter fitter = new PdfFitter("uml", "jminuit");
        fitter.setUseFunctionGradient(false);
        fitter.fit(c, (Function)g);
        plotter.region(0).plot((IFunction)g);
        plotter.show();
    }
}

