/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.extension.aida.fitter;

import hep.aida.IBaseHistogram;
import hep.aida.IDataPoint;
import hep.aida.IDataPointSet;
import hep.aida.IFitData;
import hep.aida.IFitParameterSettings;
import hep.aida.IFitResult;
import hep.aida.IFitter;
import hep.aida.IFunction;
import hep.aida.ext.IExtFitter;
import hep.aida.ref.fitter.FitFactory;
import hep.aida.ref.fitter.FitResult;
import hep.aida.ref.fitter.Fitter;
import hep.aida.ref.function.AbstractIFunction;
import hep.aida.ref.histogram.DataPointSet;
import jas.hist.FitFailed;
import jas.hist.Fittable1DFunction;
import jas.hist.FunctionValueUndefined;
import jas.hist.InvalidFunctionParameter;
import org.freehep.jas.extension.aida.function.FunctionWrapper;

public class FitterAdapter
extends jas.hist.Fitter
implements IExtFitter {
    private static FitFactory fitFactory = new FitFactory();
    private Fitter fitter;
    private IFitResult result = null;

    FitterAdapter(IFitter fitter) {
        this.fitter = (Fitter)fitter;
    }

    public FitterAdapter(String fitterName) {
        this(fitterName, "chi2");
    }

    FitterAdapter(String fitterName, String fitterType) {
        this.fitter = (Fitter)fitFactory.createFitter(fitterType, fitterName, "noClone=true");
    }

    private FitterAdapter(IFitter fitter, IFitResult result) {
        this.fitter = (Fitter)fitter;
        this.result = result;
    }

    protected void fit(Fittable1DFunction fittable1DFunction, double[] x, double[] y, double[] ey) throws FitFailed {
        Object fitFunction;
        if (fittable1DFunction instanceof IFunction) {
            fitFunction = (IFunction)fittable1DFunction;
        } else {
            String[] parNames = fittable1DFunction.getParameterNames();
            boolean[] inFitPars = fittable1DFunction.getIncludeParametersInFit();
            int freePars = fittable1DFunction.getParameterValues().length;
            String[] funcParNames = new String[freePars];
            int count = 0;
            for (int i = 0; i < inFitPars.length; ++i) {
                if (!inFitPars[i]) continue;
                funcParNames[count++] = parNames[i];
            }
            fitFunction = new Fittable1DFunctionAdapter(fittable1DFunction, funcParNames);
        }
        DataPointSet dps = new DataPointSet("pds", "", 2);
        for (int i = 0; i < x.length; ++i) {
            IDataPoint point = dps.addPoint();
            point.coordinate(0).setValue(x[i]);
            point.coordinate(1).setValue(y[i]);
            point.coordinate(1).setErrorPlus(ey[i]);
            point.coordinate(1).setErrorMinus(ey[i]);
        }
        this.result = this.fitter.fit((IDataPointSet)dps, fitFunction);
        try {
            double[] pars = this.result.fittedFunction().parameters();
            fittable1DFunction.setFit((jas.hist.Fitter)new FitterAdapter((IFitter)this.fitter, this.result), this.result.fittedFunction().parameters());
        }
        catch (InvalidFunctionParameter ifp) {
            throw new RuntimeException();
        }
    }

    public double getChiSquared() {
        if (this.result != null) {
            return this.result.quality();
        }
        return 0.0;
    }

    public double[] getParameterSigmas() {
        if (this.result != null) {
            double[] errors = new double[this.result.fittedFunction().numberOfParameters()];
            for (int i = 0; i < errors.length; ++i) {
                errors[i] = Math.sqrt(Math.abs(this.result.covMatrixElement(i, i)));
            }
            return errors;
        }
        return null;
    }

    public String[] constraints() {
        return this.fitter.constraints();
    }

    public IDataPointSet createContour(IFitData iFitData, IFitResult iFitResult, String str, String str3, int param, double param5) {
        IDataPointSet dps = this.fitter.createContour(iFitData, iFitResult, str, str3, param, param5);
        if (iFitResult.fittedFunction() instanceof Fittable1DFunction) {
            Fittable1DFunction fittable1DFunction = (Fittable1DFunction)iFitResult.fittedFunction();
            try {
                double[] pars = iFitResult.fittedFunction().parameters();
                fittable1DFunction.setFit((jas.hist.Fitter)new FitterAdapter((IFitter)this.fitter, this.result), iFitResult.fittedFunction().parameters());
            }
            catch (InvalidFunctionParameter ifp) {
                throw new RuntimeException();
            }
        }
        return dps;
    }

    public IDataPointSet createScan1D(IFitData iFitData, IFunction iFunction, String str, int param, double param4, double param5) {
        IDataPointSet dps = this.fitter.createScan1D(iFitData, iFunction, str, param, param4, param5);
        if (iFunction instanceof Fittable1DFunction) {
            Fittable1DFunction fittable1DFunction = (Fittable1DFunction)iFunction;
            try {
                double[] pars = iFunction.parameters();
                fittable1DFunction.setFit((jas.hist.Fitter)new FitterAdapter((IFitter)this.fitter, this.result), iFunction.parameters());
            }
            catch (InvalidFunctionParameter ifp) {
                throw new RuntimeException();
            }
        }
        return dps;
    }

    public String engineName() {
        return this.fitter.engineName();
    }

    private void updateFunction() {
        if (this.result != null) {
            Object f;
            IFunction func = this.result.fittedFunction();
            if (func instanceof Fittable1DFunction) {
                f = (Fittable1DFunction)func;
            } else {
                f = new FunctionWrapper(func);
                ((FitResult)this.result).setFittedFunction((IFunction)f);
            }
            try {
                double[] pars = this.result.fittedFunction().parameters();
                f.setFit((jas.hist.Fitter)new FitterAdapter((IFitter)this.fitter, this.result), this.result.fittedFunction().parameters());
            }
            catch (InvalidFunctionParameter ifp) {
                throw new RuntimeException();
            }
        }
    }

    public IFitResult fit(IFitData d, IFunction originalFunction) {
        this.result = this.fitter.fit(d, originalFunction);
        this.updateFunction();
        return this.result;
    }

    public IFitResult fit(IFitData d, IFunction originalFunction, String range) {
        this.result = this.fitter.fit(d, originalFunction, range);
        this.updateFunction();
        return this.result;
    }

    public IFitResult fit(IDataPointSet iDataPointSet, IFunction iFunction) {
        this.result = this.fitter.fit(iDataPointSet, iFunction);
        this.updateFunction();
        return this.result;
    }

    public IFitResult fit(IDataPointSet iDataPointSet, IFunction iFunction, String range) {
        this.result = this.fitter.fit(iDataPointSet, iFunction, range);
        this.updateFunction();
        return this.result;
    }

    public IFitResult fit(IDataPointSet iDataPointSet, IFunction iFunction, double[] initialParameters) {
        this.result = this.fitter.fit(iDataPointSet, iFunction, initialParameters);
        this.updateFunction();
        return this.result;
    }

    public IFitResult fit(IDataPointSet iDataPointSet, String str) {
        this.result = this.fitter.fit(iDataPointSet, str);
        this.updateFunction();
        return this.result;
    }

    public IFitResult fit(IDataPointSet iDataPointSet, String str, String range) {
        this.result = this.fitter.fit(iDataPointSet, str, range);
        this.updateFunction();
        return this.result;
    }

    public IFitResult fit(IBaseHistogram iBaseHistogram, String str) {
        this.result = this.fitter.fit(iBaseHistogram, str);
        this.updateFunction();
        return this.result;
    }

    public IFitResult fit(IBaseHistogram iBaseHistogram, String str, String range) {
        this.result = this.fitter.fit(iBaseHistogram, str, range);
        this.updateFunction();
        return this.result;
    }

    public IFitResult fit(IBaseHistogram iBaseHistogram, IFunction iFunction) {
        this.result = this.fitter.fit(iBaseHistogram, iFunction);
        this.updateFunction();
        return this.result;
    }

    public IFitResult fit(IBaseHistogram iBaseHistogram, IFunction iFunction, String range) {
        this.result = this.fitter.fit(iBaseHistogram, iFunction, range);
        this.updateFunction();
        return this.result;
    }

    public IFitResult fit(IBaseHistogram iBaseHistogram, String str, double[] values) {
        this.result = this.fitter.fit(iBaseHistogram, str, values);
        this.updateFunction();
        return this.result;
    }

    public IFitResult fit(IBaseHistogram iBaseHistogram, String str, double[] values, String range) {
        this.result = this.fitter.fit(iBaseHistogram, str, values, range);
        this.updateFunction();
        return this.result;
    }

    public IFitResult fit(IFitData iFitData, String str, double[] values) {
        this.result = this.fitter.fit(iFitData, str, values);
        this.updateFunction();
        return this.result;
    }

    public IFitResult fit(IFitData iFitData, String str, double[] values, String range) {
        this.result = this.fitter.fit(iFitData, str, values, range);
        this.updateFunction();
        return this.result;
    }

    public IFitResult fit(IDataPointSet iDataPointSet, String str, double[] values) {
        this.result = this.fitter.fit(iDataPointSet, str, values);
        this.updateFunction();
        return this.result;
    }

    public IFitResult fit(IDataPointSet iDataPointSet, String str, double[] values, String range) {
        this.result = this.fitter.fit(iDataPointSet, str, values, range);
        this.updateFunction();
        return this.result;
    }

    public IFitResult fit(IFitData iFitData, String str) {
        this.result = this.fitter.fit(iFitData, str);
        this.updateFunction();
        return this.result;
    }

    public IFitResult fit(IFitData iFitData, String str, String range) {
        this.result = this.fitter.fit(iFitData, str, range);
        this.updateFunction();
        return this.result;
    }

    public IFitResult fit(IFitData d, IFunction originalFunction, String range, Object correlationObject) {
        this.result = this.fitter.fit(d, originalFunction, range, correlationObject);
        this.updateFunction();
        return this.result;
    }

    public IFitResult fit(IDataPointSet iDataPointSet, IFunction iFunction, String range, Object correlationObject) {
        this.result = this.fitter.fit(iDataPointSet, iFunction, range, correlationObject);
        this.updateFunction();
        return this.result;
    }

    public IFitResult fit(IDataPointSet iDataPointSet, IFunction iFunction, double[] initialParameters, String range, Object correlationObject) {
        this.result = this.fitter.fit(iDataPointSet, iFunction, initialParameters, range, correlationObject);
        this.updateFunction();
        return this.result;
    }

    public IFitResult fit(IDataPointSet iDataPointSet, String str, String range, Object correlationObject) {
        this.result = this.fitter.fit(iDataPointSet, str, range, correlationObject);
        this.updateFunction();
        return this.result;
    }

    public IFitResult fit(IFitData iFitData, String str, String range, Object correlationObject) {
        this.result = this.fitter.fit(iFitData, str, range, correlationObject);
        this.updateFunction();
        return this.result;
    }

    public IFitResult fit(IDataPointSet iDataPointSet, String str, double[] values, String range, Object correlationObject) {
        this.result = this.fitter.fit(iDataPointSet, str, values, range, correlationObject);
        this.updateFunction();
        return this.result;
    }

    public IFitResult fit(IFitData iFitData, String str, double[] values, String range, Object correlationObject) {
        this.result = this.fitter.fit(iFitData, str, values, range, correlationObject);
        this.updateFunction();
        return this.result;
    }

    public String fitMethodName() {
        return this.fitter.fitMethodName();
    }

    public IFitParameterSettings fitParameterSettings(String str) {
        return this.fitter.fitParameterSettings(str);
    }

    public String[] listParameterSettings() {
        return this.fitter.listParameterSettings();
    }

    public void resetConstraints() {
        this.fitter.resetConstraints();
    }

    public void resetParameterSettings() {
        this.fitter.resetParameterSettings();
    }

    public void setConstraint(String str) throws IllegalArgumentException {
        this.fitter.setConstraint(str);
    }

    public void setEngine(String str) throws IllegalArgumentException {
        this.fitter.setEngine(str);
    }

    public void setFitMethod(String str) throws IllegalArgumentException {
        this.fitter.setFitMethod(str);
    }

    public void setUseFunctionGradient(boolean param) {
        this.fitter.setUseFunctionGradient(param);
    }

    public boolean useFunctionGradient() {
        return this.fitter.useFunctionGradient();
    }

    private class Fittable1DFunctionAdapter
    extends AbstractIFunction {
        private double[] pars;
        private Fittable1DFunction function;

        Fittable1DFunctionAdapter(Fittable1DFunction function, String[] funcParNames) {
            super("func", new String[]{"xVar"}, funcParNames);
            this.function = function;
        }

        public double value(double[] values) {
            double val = 0.0;
            try {
                val = this.function.valueAt(values[0], this.pars);
            }
            catch (FunctionValueUndefined fvu) {
                throw new RuntimeException(fvu);
            }
            return val;
        }

        public double[] parameters() {
            return this.function.getParameterValues();
        }

        public double parameter(String str) {
            int index = this.indexOfParameter(str);
            return this.parameters()[index];
        }

        public void setParameter(String str, double param) throws IllegalArgumentException {
            int index = this.indexOfParameter(str);
            this.pars[index] = param;
        }

        public void setParameters(double[] pars) throws IllegalArgumentException {
            this.pars = pars;
        }

        public String normalizationParameter() {
            return null;
        }
    }
}

