/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JToolBar;

public class ToolBarLayout
implements LayoutManager {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    int align;
    int hgap;
    int vgap;

    public ToolBarLayout() {
        this(0, 5, 5);
    }

    public ToolBarLayout(int align) {
        this(align, 5, 5);
    }

    public ToolBarLayout(int align, int hgap, int vgap) {
        this.align = align;
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public int getAlignment() {
        return this.align;
    }

    public void setAlignment(int align) {
        this.align = align;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        try {
            ((JToolBar)comp).setOrientation(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            Insets insets = target.getInsets();
            int numRows = 1;
            int rowSumWidth = insets.left + insets.right;
            int rowMaxWidth = target.getSize().width;
            int rowHeight = 0;
            int numOnRow = 0;
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getPreferredSize();
                rowHeight = Math.max(rowHeight, d.height);
                if (i > 0) {
                    rowSumWidth += this.hgap;
                }
                if ((rowSumWidth += d.width) + this.hgap > rowMaxWidth && numOnRow > 0) {
                    ++numRows;
                    rowSumWidth = insets.left + insets.right + d.width;
                    numOnRow = 0;
                }
                ++numOnRow;
            }
            dim.width = rowMaxWidth;
            dim.height = insets.top + insets.bottom + numRows * rowHeight + this.vgap * (numRows - 1);
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getMinimumSize();
                dim.height = Math.max(dim.height, d.height);
                if (i > 0) {
                    dim.width += this.hgap;
                }
                dim.width += d.width;
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right + this.hgap * 2;
            dim.height += insets.top + insets.bottom;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveComponents(Container target, int x, int y, int width, int height, int rowStart, int rowEnd) {
        Object object = target.getTreeLock();
        synchronized (object) {
            switch (this.align) {
                case 0: {
                    break;
                }
                case 1: {
                    x += width / 2;
                    break;
                }
                case 2: {
                    x += width;
                }
            }
            for (int i = rowStart; i < rowEnd; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                m.setLocation(x, y + (height - m.getSize().height) / 2);
                x += this.hgap + m.getSize().width;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            int maxwidth = target.getSize().width - (insets.left + insets.right + this.hgap * 2);
            int nmembers = target.getComponentCount();
            int x = 0;
            int y = insets.top;
            int rowh = 0;
            int start = 0;
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getPreferredSize();
                m.setSize(d.width, d.height);
                if (x == 0 || x + d.width <= maxwidth) {
                    if (x > 0) {
                        x += this.hgap;
                    }
                    x += d.width;
                    rowh = Math.max(rowh, d.height);
                    continue;
                }
                this.moveComponents(target, insets.left + this.hgap, y, maxwidth - x, rowh, start, i);
                x = d.width;
                y += this.vgap + rowh;
                rowh = d.height;
                start = i;
            }
            this.moveComponents(target, insets.left + this.hgap, y, maxwidth - x, rowh, start, nmembers);
        }
    }

    public String toString() {
        String str = "";
        switch (this.align) {
            case 0: {
                str = ",align=left";
                break;
            }
            case 1: {
                str = ",align=center";
                break;
            }
            case 2: {
                str = ",align=right";
            }
        }
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + str + "]";
    }
}

