/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.subsystem.common.PIController;
import org.lsst.ccs.subsystem.common.devices.Maq20PWMControl;
import org.lsst.ccs.utilities.logging.Logger;

public class FanControl
implements HasLifecycle {
    private Double gain;
    private Double timeConst;
    private Double smoothTime;
    private Double maxOutput = 10.0;
    private Double awGain;
    private Double baseDuty;
    private Double tolerance;
    private double minOutput = 1.0;
    private double maxInput = 100.0;
    private double minInput = -200.0;
    private Integer updateTime;
    private String[] tempChans;
    private String[] fans;
    @LookupField(strategy=LookupField.Strategy.TOP)
    Subsystem subsys;
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService pts;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Map<String, Channel> allChannels = new HashMap<String, Channel>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Map<String, Maq20PWMControl> allFans = new HashMap<String, Maq20PWMControl>();
    private final List<Channel> tempChansL = new ArrayList<Channel>();
    private final Map<String, Maq20PWMControl> fansL = new HashMap<String, Maq20PWMControl>();
    private PIController pic;
    private double lastDuty;
    private boolean active;
    private double setTemp;
    private Logger log;

    public void build() {
        this.pts.scheduleAgentPeriodicTask(new AgentPeriodicTask("fan-loop-timer", () -> this.iterateLoop()).withPeriod(Duration.ofMillis(this.updateTime.intValue())));
    }

    public void initialize(Logger log) {
        Channel cmpt;
        if (this.gain == null) {
            MonitorLogUtils.reportConfigError((Logger)log, (String)this.name, (String)"gain", (String)"is missing");
        }
        if (this.timeConst == null) {
            MonitorLogUtils.reportConfigError((Logger)log, (String)this.name, (String)"timeConst", (String)"is missing");
        }
        if (this.smoothTime == null) {
            MonitorLogUtils.reportConfigError((Logger)log, (String)this.name, (String)"smoothTime", (String)"is missing");
        }
        if (this.maxOutput == null) {
            MonitorLogUtils.reportConfigError((Logger)log, (String)this.name, (String)"maxOutput", (String)"is missing");
        }
        if (this.awGain == null) {
            MonitorLogUtils.reportConfigError((Logger)log, (String)this.name, (String)"awGain", (String)"is missing");
        }
        if (this.baseDuty == null) {
            MonitorLogUtils.reportConfigError((Logger)log, (String)this.name, (String)"baseDuty", (String)"is missing");
        }
        if (this.tolerance == null) {
            MonitorLogUtils.reportConfigError((Logger)log, (String)this.name, (String)"tolerance", (String)"is missing");
        }
        if (this.updateTime == null) {
            MonitorLogUtils.reportConfigError((Logger)log, (String)this.name, (String)"updateTime", (String)"is missing");
        }
        if (this.tempChans == null) {
            MonitorLogUtils.reportConfigError((Logger)log, (String)this.name, (String)"tempChans", (String)"is missing");
        } else {
            for (String cName : this.tempChans) {
                cmpt = this.allChannels.get(cName);
                if (cmpt != null) {
                    this.tempChansL.add(cmpt);
                    continue;
                }
                MonitorLogUtils.reportConfigError((Logger)log, (String)this.name, (String)"tempChans", (String)"contains non-Channel item");
            }
        }
        if (this.fans == null) {
            MonitorLogUtils.reportConfigError((Logger)log, (String)this.name, (String)"fans", (String)"is missing");
        } else {
            for (String cName : this.fans) {
                cmpt = this.allFans.get(cName);
                if (cmpt != null) {
                    this.fansL.put(cName, (Maq20PWMControl)cmpt);
                    continue;
                }
                MonitorLogUtils.reportConfigError((Logger)log, (String)this.name, (String)"rebs", (String)"contains non-Maq20PWMControl item");
            }
        }
        this.log = log;
        this.pic = new PIController(this.gain.doubleValue(), this.timeConst.doubleValue());
        this.pic.setSmoothTime(this.smoothTime.doubleValue());
        this.pic.setAwGain(this.awGain.doubleValue());
        this.pic.setBaseOutput(this.baseDuty.doubleValue());
        this.pic.setInputRange(this.minInput, this.maxInput);
        this.pic.setOutputRange(this.minOutput, this.maxOutput.doubleValue());
        this.pic.setTolerance(this.tolerance.doubleValue());
    }

    void setDutyCycle(double duty) {
        for (Map.Entry<String, Maq20PWMControl> e : this.fansL.entrySet()) {
            try {
                e.getValue().setDutyCycle1(duty);
            }
            catch (Exception ex) {
                this.log.error((Object)("Error setting " + e.getKey() + " fan speed: " + ex.getMessage()));
            }
        }
    }

    public void setTemperature(double temp) {
        this.setTemp = temp;
        this.pic.setSetpoint(this.setTemp);
    }

    public double getTemperature() {
        return this.setTemp;
    }

    public void setGain(double gain) {
        this.gain = gain;
        if (this.pic != null) {
            this.pic.setPID(gain, this.timeConst.doubleValue());
        }
    }

    public double getGain() {
        return this.gain;
    }

    public void setTimeConstant(double time) {
        this.timeConst = time;
        this.pic.setPID(this.gain.doubleValue(), this.timeConst.doubleValue());
    }

    public double getTimeConstant() {
        return this.timeConst;
    }

    public void startLoop(double duty) {
        if (this.active) {
            return;
        }
        this.lastDuty = 1.0 / duty;
        this.startLoop();
    }

    public void startLoop() {
        if (this.active) {
            return;
        }
        this.pic.reset();
        this.pic.setIntegral(this.lastDuty - this.baseDuty);
        this.active = true;
    }

    public void stopLoop() {
        if (!this.active) {
            return;
        }
        this.active = false;
        this.setDutyCycle(1.0);
    }

    public boolean isLoopActive() {
        return this.active;
    }

    public void reset() {
        this.pic.reset();
    }

    private void iterateLoop() {
        if (!this.active) {
            return;
        }
        int count = 0;
        double temp = 0.0;
        for (Channel tempChan : this.tempChansL) {
            double value = tempChan.getValue();
            if (Double.isNaN(value)) continue;
            temp += value;
            ++count;
        }
        if (count > 0) {
            double tod = (double)System.currentTimeMillis() / 1000.0;
            this.lastDuty = this.pic.performPI(new double[]{temp / (double)count}, tod);
            this.setDutyCycle(1.0 / this.lastDuty);
        } else {
            this.log.error((Object)"Control loop iteration failed: no valid temperature values available");
        }
    }
}

