/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility;

import java.io.Serializable;
import java.time.Duration;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.subsystem.utility.FanControl;
import org.lsst.ccs.subsystem.utility.data.UtilityState;
import org.lsst.ccs.utilities.logging.Logger;

public class AuxTest
implements HasLifecycle {
    @LookupField(strategy=LookupField.Strategy.TOP)
    Subsystem subsys;
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private FanControl fanControl;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService pts;
    private static final Logger LOG = Logger.getLogger((String)AuxTest.class.getName());
    private int ctrlState = 0;
    private double coldTemp;
    private double dutyCycle;

    public void postInit() {
        this.subsys.setAgentProperty("auxtestType", AuxTest.class.getCanonicalName());
        if (this.fanControl != null) {
            this.fanControl.initialize(LOG);
        } else {
            LOG.warn((Object)"No fan control available");
        }
    }

    public void postStart() {
        LOG.info((Object)"AuxTest subsystem started");
    }

    public UtilityState getState() {
        return new UtilityState(this.getTickPeriod(), this.ctrlState, this.coldTemp, this.dutyCycle, this.fanControl == null ? 0.0 : this.fanControl.getGain(), this.fanControl == null ? 0.0 : this.fanControl.getTimeConstant());
    }

    @Command(type=Command.CommandType.QUERY, description="Get the AuxTest system state")
    public UtilityState getSystemState() {
        return this.getState();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the update interval")
    public void setUpdatePeriod(@Argument(description="The tick period (ms)") int value) {
        this.setTickPeriod(value);
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the fan control state")
    public void setControlState(@Argument(description="The control state") int state) {
        if (state == this.ctrlState) {
            return;
        }
        if (state == 2) {
            if (this.fanControl != null) {
                this.fanControl.setTemperature(this.coldTemp);
                this.fanControl.startLoop(this.dutyCycle);
            }
        } else if (this.fanControl != null) {
            this.fanControl.stopLoop();
            if (state == 1) {
                this.fanControl.setDutyCycle(this.dutyCycle);
            }
        }
        this.ctrlState = state;
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the manual fan speed")
    public void setFanSpeed(@Argument(description="The duty cycle") double duty) {
        this.dutyCycle = duty;
        if (this.fanControl != null && this.ctrlState == 1) {
            this.fanControl.setDutyCycle(this.dutyCycle);
        }
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the cold temperature")
    public void setColdTemp(@Argument(description="The cold temperature") double temp) {
        this.coldTemp = temp;
        if (this.fanControl != null && this.ctrlState == 2) {
            this.fanControl.setTemperature(this.coldTemp);
        }
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the control loop gain")
    public void setGain(@Argument(description="The loop gain") double gain) {
        if (this.fanControl != null) {
            this.fanControl.setGain(gain);
        }
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the control loop time constant")
    public void setTimeConstant(@Argument(description="The loop time constant") double time) {
        if (this.fanControl != null) {
            this.fanControl.setTimeConstant(time);
        }
        this.publishState();
    }

    private void publishState() {
        this.subsys.publishSubsystemDataOnStatusBus(new KeyValueData("UtilityState", (Serializable)this.getState()));
    }

    private void setTickPeriod(long period) {
        this.pts.setPeriodicTaskPeriod("monitor-publish", Duration.ofMillis(period));
    }

    private int getTickPeriod() {
        return (int)this.pts.getPeriodicTaskPeriod("monitor-publish").toMillis();
    }
}

