/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.io.Serializable;
import java.util.Iterator;
import java.util.function.Predicate;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.CommandArgumentMatchException;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.DictionaryCompleter;
import org.lsst.ccs.command.DictionaryHelpGenerator;
import org.lsst.ccs.command.annotations.Command;

public interface Dictionary
extends Iterable<DictionaryCommand>,
Serializable {
    public boolean containsCommand(BasicCommand var1) throws CommandArgumentMatchException;

    public DictionaryCommand findCommand(BasicCommand var1) throws CommandArgumentMatchException;

    public int size();

    default public DictionaryHelpGenerator getHelpGenerator() {
        return null;
    }

    default public DictionaryCompleter getDictionaryCompleter() {
        return null;
    }

    public void setLevelForTypes(int var1, Command.CommandType ... var2);

    public int getLevelForType(Command.CommandType var1);

    default public boolean isDictionaryCommandVisible(DictionaryCommand dc) {
        return dc.getLevel() <= this.getLevelForType(dc.getType());
    }

    default public Iterable<DictionaryCommand> filterByLevelIterator() {
        return new Iterable<DictionaryCommand>(){

            @Override
            public Iterator<DictionaryCommand> iterator() {
                Iterator<DictionaryCommand> filteredIterator = new Iterator<DictionaryCommand>(){
                    private final Iterator<DictionaryCommand> superIterator;
                    private boolean hasNext;
                    private DictionaryCommand nextDC;
                    private final Predicate<DictionaryCommand> pred;
                    {
                        this.superIterator = Dictionary.this.iterator();
                        this.nextDC = null;
                        this.pred = dc -> Dictionary.this.isDictionaryCommandVisible((DictionaryCommand)dc);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.hasNext;
                    }

                    @Override
                    public DictionaryCommand next() {
                        DictionaryCommand prevDC = this.nextDC;
                        while (this.superIterator.hasNext()) {
                            DictionaryCommand dc = this.superIterator.next();
                            if (!this.pred.test(dc)) continue;
                            this.hasNext = true;
                            this.nextDC = dc;
                            return prevDC;
                        }
                        this.hasNext = false;
                        return prevDC;
                    }
                };
                filteredIterator.next();
                return filteredIterator;
            }
        };
    }
}

