/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.cli.ParseException;
import org.lsst.ccs.bootstrap.Bootstrap;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bootstrap.BootstrapUtils;

class BootstrapEnvironmentUtils {
    private static final String sysPropFlag = "system.property.";
    private static final String jvmOptFlag = "system.option.";

    BootstrapEnvironmentUtils() {
    }

    public static void main(String[] argv) {
        String arg = argv[0];
        if (arg.equals("LD_LIBRARY_PATH")) {
            System.out.println(BootstrapEnvironmentUtils.getBootstrapLibraryPath(argv));
        } else if (arg.equals("JAVA_OPTS")) {
            System.out.println(BootstrapEnvironmentUtils.getJavaOpts(argv));
        } else if (arg.equals("CLASSPATH")) {
            System.out.println(BootstrapEnvironmentUtils.getClasspath(argv));
        } else {
            throw new IllegalArgumentException("Illegal Option " + arg);
        }
    }

    static String getJavaOpts(String[] argv) {
        return BootstrapEnvironmentUtils.getJavaOpts(argv, "system");
    }

    static String getJavaOpts(String[] argv, String fileName) {
        StringBuilder output = new StringBuilder();
        Bootstrap b = new Bootstrap(true);
        try {
            b.parseCommandLineArguments(argv);
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
        Properties p = BootstrapResourceUtils.getBootstrapProperties(fileName);
        Set<Object> keys = BootstrapResourceUtils.getAllKeysInProperties(p);
        for (Object key : keys) {
            String keyStr = (String)key;
            if (keyStr.startsWith(sysPropFlag)) {
                String sysPropertyForJava = keyStr.replace(sysPropFlag, "");
                String sysPropertyValue = p.getProperty(keyStr);
                if (sysPropertyValue == null || sysPropertyValue.isEmpty()) continue;
                output.append("-D");
                output.append(sysPropertyForJava);
                output.append("=");
                output.append(BootstrapUtils.parseProperty(sysPropertyValue));
                output.append(" ");
                continue;
            }
            if (!keyStr.startsWith(jvmOptFlag)) continue;
            String sysOptionForJava = keyStr.replace(jvmOptFlag, "");
            output.append("-");
            output.append(sysOptionForJava);
            String sysOptionValue = p.getProperty(keyStr);
            if (sysOptionValue != null && !sysOptionValue.isEmpty()) {
                output.append(BootstrapUtils.parseProperty(sysOptionValue));
            }
            output.append(" ");
        }
        return output.toString();
    }

    static String getClasspath(String[] argv) {
        StringBuilder output = new StringBuilder();
        Bootstrap b = new Bootstrap(true);
        try {
            b.parseCommandLineArguments(argv);
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
        URLClassLoader loader = Bootstrap.getBootstrapApplicationClassLoader();
        URL[] urls = loader.getURLs();
        try {
            for (URL url : urls) {
                output.append(Paths.get(url.toURI())).append(BootstrapUtils.PATH_SEPARATOR);
            }
        }
        catch (URISyntaxException x) {
            throw new RuntimeException(x);
        }
        String ret = output.toString();
        return ret.substring(0, ret.length() - 1);
    }

    static String getBootstrapLibraryPath(String[] argv) {
        Properties p;
        String additionalLibraryPathProperty;
        Bootstrap b = new Bootstrap(true);
        try {
            b.parseCommandLineArguments(argv);
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
        String libraryPath = BootstrapUtils.getDistributionJniDirectory() + File.pathSeparator + BootstrapUtils.getDistributionLibDirectory();
        String existingLibraryPath = System.getenv("LD_LIBRARY_PATH");
        if (existingLibraryPath != null && !existingLibraryPath.isEmpty()) {
            libraryPath = libraryPath + File.pathSeparator + existingLibraryPath;
        }
        if (!(additionalLibraryPathProperty = (p = BootstrapResourceUtils.getBootstrapProperties("system")).getProperty("org.lsst.ccs.ld.library.path", "")).isEmpty()) {
            List<String> dirs = BootstrapUtils.extractDirectoriesFromPath(BootstrapUtils.getDistributionLibDirectory(), additionalLibraryPathProperty, null, false);
            for (String dir : dirs) {
                libraryPath = libraryPath + File.pathSeparator + dir;
            }
        }
        return libraryPath;
    }
}

