/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.messaging.DummyLock;
import org.lsst.ccs.services.AbstractAgentLockServiceDelegate;
import org.lsst.ccs.services.AgentLockService;
import org.lsst.ccs.services.UnauthorizedLevelException;
import org.lsst.ccs.services.UnauthorizedLockException;

public class LocalAgentLockService
extends AbstractAgentLockServiceDelegate {
    public LocalAgentLockService(AgentLockService svc) {
        super(svc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLevelForAgent(String agentName, int level) throws UnauthorizedLevelException, UnauthorizedLockException, IOException {
        Object object = this.lockLevelUpdate;
        synchronized (object) {
            AgentLock lock = (AgentLock)this.heldLocks.get(agentName);
            if (lock == null) {
                this.lockAgent(agentName);
            }
            this.setLevelInternal(agentName, level);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lockAgent(String agentName) throws UnauthorizedLockException, IOException {
        Object object = this.lockLevelUpdate;
        synchronized (object) {
            if (this.heldLocks.get(agentName) != null) {
                return;
            }
            log.fine((Object)("acquiring lock for " + agentName));
            DummyLock lock = new DummyLock(agentName, this.getAgent().getName());
            this.setLockInternal(agentName, (AgentLock)lock);
            log.fine((Object)(this.getAgent().getName() + " acquired a lock for agent " + agentName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockAgent(String agentName) throws IOException {
        Object object = this.lockLevelUpdate;
        synchronized (object) {
            try {
                this.setLevelInternal(agentName, 0);
                this.setLockInternal(agentName, null);
            }
            catch (UnauthorizedLevelException | UnauthorizedLockException ex) {
                log.warning((Object)"Something went really wrong as we should not get these exceptions when unlocking.", (Throwable)ex);
            }
            log.fine((Object)(this.getAgent().getName() + " released a lock for agent " + agentName));
        }
    }

    @Override
    public boolean validateLock(AgentLock lock) {
        return true;
    }

    @Override
    public Map<String, AgentLock> getLocks() {
        return Collections.EMPTY_MAP;
    }

    @Override
    public void preStart() {
    }
}

