/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility.data;

import java.io.Serializable;
import java.util.Arrays;
import org.lsst.ccs.subsystem.utility.constants.ConditionState;
import org.lsst.ccs.subsystem.utility.constants.LatchState;
import org.lsst.ccs.subsystem.utility.constants.PLCState;
import org.lsst.ccs.subsystem.utility.constants.SwitchState;

public class MpmSysState
implements Serializable {
    public static final String KEY = "MPMState";
    public static final int PLC_TRUNK = 0;
    public static final int PLC_COLD = 1;
    public static final int PLC_CRYO = 2;
    public static final int NUM_PLCS = 3;
    public static final int SW_BLOCK_UT_POWER = 0;
    public static final int SW_BLOCK_REB_POWER = 1;
    public static final int SW_BLOCK_COOLANT = 2;
    public static final int SW_BLOCK_COLD_REFG = 3;
    public static final int SW_BLOCK_COLD_HEAT = 4;
    public static final int SW_BLOCK_CRYO_REFG = 5;
    public static final int SW_BLOCK_CRYO_HEAT = 6;
    public static final int NUM_SWITCHES = 7;
    public static final int LATCH_UT_TEMP = 0;
    public static final int LATCH_UT_LEAK = 1;
    public static final int LATCH_UT_LEAK_FAULT = 2;
    public static final int LATCH_UT_SMOKE = 3;
    public static final int LATCH_UT_SMOKE_FAULT = 4;
    public static final int LATCH_COLD_TEMP_HIGH = 5;
    public static final int LATCH_COLD_TEMP_LOW = 6;
    public static final int LATCH_CRYO_TEMP_HIGH = 7;
    public static final int LATCH_CRYO_TEMP_LOW = 8;
    public static final int LATCH_CRYO_VACUUM = 9;
    public static final int LATCH_HEX_VACUUM = 10;
    public static final int NUM_LATCHES = 11;
    public static final int COND_UT_POWER = 0;
    public static final int COND_REB_POWER = 1;
    public static final int COND_COOLANT = 2;
    public static final int COND_COLD_REFG = 3;
    public static final int COND_COLD_HEAT = 4;
    public static final int COND_CRYO_REFG = 5;
    public static final int COND_CRYO_HEAT = 6;
    public static final int NUM_CONDITIONS = 7;
    private int tickMillis;
    private final PLCState[] plcState = new PLCState[3];
    private final SwitchState[] switchState = new SwitchState[7];
    private final LatchState[] latchState = new LatchState[11];
    private final ConditionState[] conditionState = new ConditionState[7];
    private static final long serialVersionUID = -8032854988404965419L;

    public MpmSysState() {
        Arrays.fill((Object[])this.plcState, (Object)PLCState.ALIVE);
        Arrays.fill((Object[])this.switchState, (Object)SwitchState.OFFLINE);
        Arrays.fill((Object[])this.latchState, (Object)LatchState.OFFLINE);
        Arrays.fill((Object[])this.conditionState, (Object)ConditionState.OFF);
    }

    public void setTickMillis(int value) {
        this.tickMillis = value;
    }

    public int getTickMillis() {
        return this.tickMillis;
    }

    public void setPlcState(int plc, PLCState value) {
        this.plcState[plc] = value;
    }

    public PLCState getPlcState(int plc) {
        return this.plcState[plc];
    }

    public void setSwitchState(int sw, SwitchState state) {
        this.switchState[sw] = state;
    }

    public SwitchState getSwitchState(int sw) {
        return this.switchState[sw];
    }

    public void setLatch(int latch, LatchState state) {
        this.latchState[latch] = state;
    }

    public LatchState getLatch(int latch) {
        return this.latchState[latch];
    }

    public void setCondition(int cond, ConditionState state) {
        this.conditionState[cond] = state;
    }

    public ConditionState getCondition(int cond) {
        return this.conditionState[cond];
    }
}

