/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.tree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.freehep.jas.plugin.tree.DefaultFTreeNode;
import org.freehep.jas.plugin.tree.DefaultFTreeNodeAdapterManager;
import org.freehep.jas.plugin.tree.DefaultJTree;
import org.freehep.jas.plugin.tree.FTree;
import org.freehep.jas.plugin.tree.FTreeFolderNode;
import org.freehep.jas.plugin.tree.FTreeNode;
import org.freehep.jas.plugin.tree.FTreeNodeAdapter;
import org.freehep.jas.plugin.tree.FTreeNodeAddedNotification;
import org.freehep.jas.plugin.tree.FTreeNodeEvent;
import org.freehep.jas.plugin.tree.FTreeNodeExpandedNotification;
import org.freehep.jas.plugin.tree.FTreeNodeMovedNotification;
import org.freehep.jas.plugin.tree.FTreeNodeRemovedNotification;
import org.freehep.jas.plugin.tree.FTreeNodeRenamedNotification;
import org.freehep.jas.plugin.tree.FTreeNodeRepaintNotification;
import org.freehep.jas.plugin.tree.FTreeNodeSelectionNotification;
import org.freehep.jas.plugin.tree.FTreeNodeSorterNotification;
import org.freehep.jas.plugin.tree.FTreeNodeStructureChangedNotification;
import org.freehep.jas.plugin.tree.FTreeNotification;
import org.freehep.jas.plugin.tree.FTreePath;
import org.freehep.jas.plugin.tree.FTreePlugin;
import org.freehep.jas.plugin.tree.FTreeSelectionManager;
import org.freehep.jas.plugin.tree.FTreeUtils;
import org.jdom.Content;
import org.jdom.Element;

class DefaultFTree
extends DefaultTreeModel
implements Runnable,
FTree {
    private List queue;
    private DefaultJTree jTree;
    private String name;
    private DefaultFTreeNodeAdapterManager adapterManager;

    DefaultFTree(DefaultFTreeNode root) {
        super(root, true);
        root.setDefaultTree(this);
        this.name = root.realName();
        this.adapterManager = new DefaultFTreeNodeAdapterManager(this);
        FTreePlugin thePlugin = FTreePlugin.plugin();
        root.setSorting(thePlugin.treeSortingAlgorithm(this.name), thePlugin.isTreeSortingRecursive(this.name));
    }

    protected void setJTree(DefaultJTree jTree) {
        this.jTree = jTree;
    }

    DefaultJTree jTree() {
        return this.jTree;
    }

    @Override
    public FTreeNode root() {
        return (FTreeNode)this.getRoot();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public synchronized void treeChanged(FTreeNotification notification) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (this.queue != null) {
                this.run();
            }
            this.processTreeNotification(notification);
        } else {
            boolean wasEmpty;
            boolean bl = wasEmpty = this.queue == null;
            if (wasEmpty) {
                this.queue = new ArrayList();
            }
            this.queue.add(notification);
            if (wasEmpty) {
                SwingUtilities.invokeLater(this);
            }
        }
    }

    @Override
    public void nodeStructureChanged(TreeNode node) {
        Element el = new Element("root");
        this.saveNodeStructure((DefaultFTreeNode)node, el);
        super.nodeStructureChanged(node);
        this.restoreNodeStructure((DefaultFTreeNode)node, el.getChild("node"), true, new ArrayList());
    }

    private void saveNodeStructure(DefaultFTreeNode node, Element el) {
        if (node.childrenChecked() && this.isNodeExpanded(node)) {
            Element e = new Element("node");
            e.setAttribute("name", node.realName());
            if (this.isNodeSelected(node)) {
                e.setAttribute("isSelected", "true");
            }
            int nChild = node.getChildCount();
            for (int i = 0; i < nChild; ++i) {
                DefaultFTreeNode n = (DefaultFTreeNode)node.getChildAt(i);
                if (!this.isNodeExpanded(n)) continue;
                this.saveNodeStructure(n, e);
            }
            el.addContent((Content)e);
        }
    }

    private void restoreNodeStructure(DefaultFTreeNode node, Element el, boolean finalize, List selNodes) {
        if (el == null) {
            return;
        }
        if (finalize && selNodes == null) {
            selNodes = new ArrayList<DefaultFTreeNode>();
        }
        List nodes = el.getChildren("node");
        String isSelected = el.getAttributeValue("isSelected");
        if (isSelected != null) {
            selNodes.add(node);
        }
        for (int i = 0; i < nodes.size(); ++i) {
            Element childEl = (Element)nodes.get(i);
            String childName = childEl.getAttributeValue("name");
            DefaultFTreeNode childNode = node.find(childName);
            if (childNode == null) continue;
            this.expandNode(childNode);
            this.restoreNodeStructure(childNode, childEl, false, selNodes);
        }
        if (finalize) {
            DefaultFTreeNode[] selectedNodes = new DefaultFTreeNode[selNodes.size()];
            for (int i = 0; i < selectedNodes.length; ++i) {
                selectedNodes[i] = (DefaultFTreeNode)selNodes.get(i);
            }
            this.selectNodes(selectedNodes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Iterator iter;
        DefaultFTree defaultFTree = this;
        synchronized (defaultFTree) {
            iter = this.queue.iterator();
            this.queue = null;
        }
        while (iter.hasNext()) {
            FTreeNotification notification = (FTreeNotification)iter.next();
            this.processTreeNotification(notification);
        }
    }

    private boolean addNodeToParent(FTreeNodeAddedNotification event) {
        DefaultFTreeNode parent = (DefaultFTreeNode)this.findParent(event);
        if (parent == null) {
            if (!this.addNodeToParent(new FTreeNodeAddedNotification(event.getSource(), event.nodePath().getParentPath(), FTreeFolderNode.class))) {
                return false;
            }
            parent = (DefaultFTreeNode)this.findParent(event);
        }
        if (!parent.getAllowsChildren()) {
            throw new IllegalArgumentException("Cannot add nodes to " + parent + "! It doesn't allow children");
        }
        DefaultFTreeNode node = new DefaultFTreeNode(event, this);
        if (!parent.addNode(node)) {
            return false;
        }
        int indexOfChild = parent.getIndex(node);
        this.nodesWereInserted(parent, new int[]{indexOfChild});
        return true;
    }

    private void processTreeNotification(FTreeNotification notification) {
        Class<?> eventClass = notification.getClass();
        if (eventClass == FTreeNodeAddedNotification.class) {
            FTreeNodeAddedNotification event = (FTreeNodeAddedNotification)notification;
            if (this.findNode(event) != null) {
                throw new IllegalArgumentException("Node " + event.nodePath() + " already exists!");
            }
            this.addNodeToParent(event);
            this.jTree.repaint();
        } else if (eventClass == FTreeNodeRemovedNotification.class) {
            FTreeNodeRemovedNotification event = (FTreeNodeRemovedNotification)notification;
            DefaultFTreeNode node = (DefaultFTreeNode)this.findNode(event);
            this.adapterManager().closeNode(node);
            DefaultFTreeNode parent = (DefaultFTreeNode)node.getParent();
            int n = parent.getIndex(node);
            if (parent.removeNode(node)) {
                this.nodesWereRemoved(parent, new int[]{n}, new Object[]{node});
            }
        } else if (eventClass == FTreeNodeRenamedNotification.class) {
            FTreeNodeRenamedNotification event = (FTreeNodeRenamedNotification)notification;
            DefaultFTreeNode node = (DefaultFTreeNode)this.findNode(event);
            node.setName(event.nodeNewName());
            this.nodeChanged(node);
            node.fireFTreeNodeEvent(new FTreeNodeEvent(node, node, 2));
        } else if (eventClass == FTreeNodeRepaintNotification.class) {
            boolean recursive = ((FTreeNodeRepaintNotification)notification).isRecursive();
            DefaultFTreeNode node = (DefaultFTreeNode)this.findNode(notification);
            this.updateNode(node, recursive);
            if (!recursive) {
                node.fireFTreeNodeEvent(new FTreeNodeEvent(node, node, 2));
            } else {
                node.fireFTreeNodeEvent(new FTreeNodeEvent(node, node, 3));
            }
        } else if (eventClass == FTreeNodeStructureChangedNotification.class) {
            FTreeNodeStructureChangedNotification event = (FTreeNodeStructureChangedNotification)notification;
            DefaultFTreeNode node = (DefaultFTreeNode)event.node();
            this.nodeStructureChanged(node);
            node.fireFTreeNodeEvent(new FTreeNodeEvent(node, node, 3));
        } else if (eventClass == FTreeNodeExpandedNotification.class) {
            DefaultFTreeNode node = (DefaultFTreeNode)this.findNode(notification);
            this.expandNode(node);
            node.fireFTreeNodeEvent(new FTreeNodeEvent(node, node, 3));
        } else if (eventClass == FTreeNodeMovedNotification.class) {
            FTreeNodeMovedNotification event = (FTreeNodeMovedNotification)notification;
            DefaultFTreeNode node = (DefaultFTreeNode)this.findNode(event);
            DefaultFTreeNode parent = (DefaultFTreeNode)node.parent();
            DefaultFTreeNode newParent = (DefaultFTreeNode)this.findNode(event.nodeNewPath().getParentPath());
            String newName = event.nodeNewPath().getLastPathComponent();
            if (parent != newParent) {
                if (!newParent.getAllowsChildren()) {
                    throw new IllegalArgumentException("Cannot move node to " + newParent + "! It doesn't allow children");
                }
                parent.removeNode(node);
                newParent.addNode(node);
                node.setName(newName);
                this.nodeStructureChanged(parent);
                this.nodeStructureChanged(newParent);
            } else {
                node.setName(newName);
                this.nodeChanged(node);
                node.fireFTreeNodeEvent(new FTreeNodeEvent(node, node, 2));
            }
        } else if (eventClass == FTreeNodeSorterNotification.class) {
            DefaultFTreeNode node = (DefaultFTreeNode)this.findNode(notification);
            String sortingString = ((FTreeNodeSorterNotification)notification).sortingString();
            boolean recursive = ((FTreeNodeSorterNotification)notification).recursive();
            node.applySorting(sortingString, recursive);
            node.fireFTreeNodeEvent(new FTreeNodeEvent(node, node, 3));
        } else if (eventClass == FTreeNodeSelectionNotification.class) {
            this.selectionManager().selectionChange((FTreeNodeSelectionNotification)notification);
        } else {
            throw new IllegalArgumentException("Unsupported FTreeNotification class " + eventClass);
        }
    }

    private void updateNode(DefaultFTreeNode node, boolean recursive) {
        this.nodeChanged(node);
        if (this.isNodeExpanded(node)) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                if (recursive) {
                    this.updateNode((DefaultFTreeNode)node.getChildAt(i), recursive);
                    continue;
                }
                this.nodeChanged(node.getChildAt(i));
            }
        }
    }

    void selectNodes(DefaultFTreeNode[] selNodes) {
        TreePath[] selPath = new TreePath[selNodes.length];
        for (int i = 0; i < selPath.length; ++i) {
            selPath[i] = FTreeUtils.treePathForNode(selNodes[i]);
        }
        this.jTree.setSelectionPaths(selPath);
    }

    void selectNode(DefaultFTreeNode node) {
        this.jTree.setSelectionPath(FTreeUtils.treePathForNode(node));
    }

    void expandNode(DefaultFTreeNode node) {
        this.jTree.expandPath(FTreeUtils.treePathForNode(node));
    }

    boolean isNodeExpanded(DefaultFTreeNode node) {
        TreePath path = FTreeUtils.treePathForNode(node);
        return this.jTree.isExpanded(path);
    }

    boolean isNodeSelected(DefaultFTreeNode node) {
        TreePath path = FTreeUtils.treePathForNode(node);
        return this.jTree.isPathSelected(path);
    }

    private FTreeNode findNode(FTreeNotification e) {
        return this.findNode(e.nodePath());
    }

    @Override
    public FTreeNode findNode(FTreePath path) {
        if (path == null) {
            return this.findNode(path, 0);
        }
        return this.findNode(path, path.getPathCount());
    }

    private FTreeNode findNode(FTreePath path, int depth) {
        DefaultFTreeNode node = (DefaultFTreeNode)this.root();
        FTreePath treePath = null;
        for (int i = 0; i < depth; ++i) {
            DefaultFTreeNode child;
            String name = path.getPathComponent(i);
            treePath = treePath == null ? new FTreePath(name) : treePath.pathByAddingChild(name);
            if (node == null) {
                return null;
            }
            node = child = node.find(name);
        }
        return node;
    }

    private FTreeNode findParent(FTreeNotification e) {
        return this.findNode(e.nodePath(), e.nodePath().getPathCount() - 1);
    }

    public FTreeSelectionManager selectionManager() {
        return this.jTree.selectionManager();
    }

    @Override
    public FTreeNode[] selectedNodes() {
        return this.selectionManager().selectedNodes();
    }

    DefaultFTreeNodeAdapterManager adapterManager() {
        return this.adapterManager;
    }

    @Override
    public FTreeNodeAdapter adapterForClass(Class clazz) {
        return this.adapterManager().adapterForClass(clazz);
    }

    @Override
    public FTreeNodeAdapter[] adaptersForClass(Class clazz) {
        return this.adapterManager().adaptersForClass(clazz);
    }
}

