/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.pattern;

import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileNamePatternUtils {
    private static final Pattern variablePattern = Pattern.compile("(\\{([\\w/]+){1}}).*");

    public static String resolveFileName(String fileNamePattern, Map<String, String> map) {
        Properties p = new Properties();
        for (String key : map.keySet()) {
            p.setProperty(key, map.get(key));
        }
        return FileNamePatternUtils.resolveFileName(fileNamePattern, p);
    }

    public static String resolveFileName(String fileNamePattern, Properties props) {
        String[] parts = fileNamePattern.split("\\$");
        if (parts.length < 2) {
            return fileNamePattern;
        }
        String resolvedFileName = parts[0];
        for (int i = 1; i < parts.length; ++i) {
            resolvedFileName = resolvedFileName + FileNamePatternUtils.resolvePart(parts[i], props);
        }
        return resolvedFileName;
    }

    private static String resolvePart(String part, Properties props) {
        String group;
        String variableName;
        String value;
        Matcher m = variablePattern.matcher(part);
        if (m.matches() && (value = props.getProperty(variableName = (group = m.group(1)).substring(1, group.length() - 1), null)) != null) {
            return part.replace("{" + variableName + "}", value);
        }
        return "$" + part;
    }
}

