/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.shell;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jline.console.ConsoleReader;
import jline.console.completer.Completer;
import jline.console.completer.CompletionHandler;
import jline.console.history.FileHistory;
import jline.console.history.History;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.command.AmbiguousCommandException;
import org.lsst.ccs.command.CommandArgumentMatchException;
import org.lsst.ccs.command.CommandArgumentTypeException;
import org.lsst.ccs.command.CommandInvocationException;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.CompositeCommandSet;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCompleter;
import org.lsst.ccs.command.HelpGenerator;
import org.lsst.ccs.command.TokenizedCommand;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.shell.CommandCompletionHandler;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.pattern.PatternUtils;

public class JLineShell {
    private final CommandSet commands;
    private boolean exitRequested;
    private ConsoleReader reader;
    private final PrintWriter printWriter;
    private Exception lastException;
    private final Prompt prompt;
    private static final Logger logger = Logger.getLogger((String)JLineShell.class.getName());
    private String defaultHistoryFilePattern = "%W/shell/%A-shell.history";

    public JLineShell(CommandSet userCommands) throws IOException {
        this(userCommands, new ConsoleReader(), null);
    }

    public JLineShell(CommandSet userCommands, ConsoleReader reader) {
        this(userCommands, reader, null);
    }

    public JLineShell(CommandSet userCommands, String prompt) throws IOException {
        this(userCommands, new ConsoleReader(), prompt);
    }

    public JLineShell(CommandSet userCommands, ConsoleReader reader, String prompt) {
        this.reader = reader;
        this.prompt = new Prompt(prompt);
        this.printWriter = new PrintWriter(reader.getOutput(), true);
        this.printWriter.println("Type help for list of available commands");
        CompositeCommandSet allCommands = new CompositeCommandSet();
        CommandSetBuilder builder = new CommandSetBuilder();
        allCommands.add(builder.buildCommandSet(new BuiltIns()));
        allCommands.add(userCommands);
        this.commands = allCommands;
        Dictionary commandDictionary = this.commands.getCommandDictionary();
        final DictionaryCompleter dictionaryCompleter = commandDictionary.getDictionaryCompleter();
        HelpGenerator helpGenerator = new HelpGenerator(this.printWriter, commandDictionary);
        allCommands.add(helpGenerator.getCommandSet());
        Completer completer = new Completer(){

            public int complete(String string, int i, List<CharSequence> list) {
                return dictionaryCompleter.complete(string, i, list);
            }
        };
        reader.addCompleter(completer);
        reader.setCompletionHandler((CompletionHandler)new CommandCompletionHandler());
    }

    private void setDefaultHistoryFilePatter(String pattern) {
        this.defaultHistoryFilePattern = pattern;
    }

    private String getHistoryFilePattern() {
        return BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.command.history.file", this.defaultHistoryFilePattern);
    }

    public void run() throws IOException {
        this.loadHistory();
        while (!this.exitRequested) {
            if (this.prompt.isDynamic()) {
                this.prompt.setDynamicPrompt(this.commands);
            }
            String command = null;
            boolean illegalInput = false;
            try {
                command = this.reader.readLine();
            }
            catch (IllegalArgumentException iae) {
                this.reader.setCursorPosition(0);
                this.reader.killLine();
                this.printWriter.println(iae.getMessage());
                illegalInput = true;
            }
            if (illegalInput) continue;
            if (command == null) {
                this.printWriter.println();
                break;
            }
            try {
                Object result;
                TokenizedCommand tc = new TokenizedCommand(command);
                if (tc.isEmpty() || (result = this.commands.invoke(tc)) == null) continue;
                try {
                    if (result.getClass().isArray()) {
                        this.printObjectAsArray(this.printWriter, result);
                        continue;
                    }
                    this.printWriter.println(result.toString());
                }
                catch (Exception e) {
                    this.printWriter.println("Error when displaying the command result (type st for stacktrace): " + e.getMessage());
                    this.lastException = e;
                }
            }
            catch (AmbiguousCommandException | CommandArgumentMatchException | CommandArgumentTypeException | CommandInvocationException ex) {
                this.printWriter.println("Error (type st for stacktrace): " + ex.getMessage());
                this.lastException = ex;
            }
        }
        this.saveHistory();
    }

    private void printObjectAsArray(PrintWriter printWriter, Object result) {
        if (result instanceof int[]) {
            printWriter.println(Arrays.toString((int[])result));
        } else if (result instanceof float[]) {
            printWriter.println(Arrays.toString((float[])result));
        } else if (result instanceof double[]) {
            printWriter.println(Arrays.toString((double[])result));
        } else if (result instanceof long[]) {
            printWriter.println(Arrays.toString((long[])result));
        } else if (result instanceof boolean[]) {
            printWriter.println(Arrays.toString((boolean[])result));
        } else if (result instanceof byte[]) {
            printWriter.println(Arrays.toString((byte[])result));
        } else if (result instanceof short[]) {
            printWriter.println(Arrays.toString((short[])result));
        } else if (result instanceof char[]) {
            printWriter.println(Arrays.toString((char[])result));
        } else {
            printWriter.println(Arrays.deepToString((Object[])result));
        }
    }

    private void loadHistory() {
        File f = this.getHistoryFile();
        try {
            FileHistory history = new FileHistory(f);
            this.reader.setHistory((History)history);
        }
        catch (IOException x) {
            logger.warning((Object)"Unable to load command history", (Throwable)x);
        }
    }

    private void saveHistory() throws IOException {
        ((FileHistory)this.reader.getHistory()).flush();
    }

    private File getHistoryFile() {
        String outputFile = PatternUtils.resolvePattern((String)this.getHistoryFilePattern());
        File workDir = new File(outputFile.substring(0, outputFile.lastIndexOf("/")));
        workDir.mkdirs();
        return new File(outputFile);
    }

    public static void main(String[] argv) throws Exception {
        Options shellOptions = new Options();
        shellOptions.addOption("h", "help", false, "Print the help message");
        shellOptions.addOption("dc", "dictionaryClasses", true, "The comma separated list of classes to be used to build the command dictionary.\nThe dictionary classes must have an empty constructor in order to be loaded.");
        shellOptions.addOption("p", "prompt", true, "Set the initial prompt");
        BasicParser parser = new BasicParser();
        CommandLine line = parser.parse(shellOptions, argv, true);
        if (line.hasOption("help")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(80, "CommandShell", "", shellOptions, "", true);
        } else {
            CommandSetBuilder builder = new CommandSetBuilder();
            CompositeCommandSet compositeSet = new CompositeCommandSet();
            String dictionaryClasses = line.getOptionValue("dictionaryClasses");
            String dictionaryContent = "";
            if (dictionaryClasses != null) {
                String[] classTokens;
                for (String className : classTokens = dictionaryClasses.split(",")) {
                    try {
                        Class<?> c = Class.forName(className);
                        Object obj = c.newInstance();
                        compositeSet.add(builder.buildCommandSet(obj));
                        dictionaryContent = dictionaryContent + "-" + className.substring(className.lastIndexOf(".") + 1);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        logger.warning((Object)("Skipping class " + className + ". It could not be loaded or created."), (Throwable)e);
                    }
                }
            }
            JLineShell shell = new JLineShell((CommandSet)compositeSet, line.getOptionValue("prompt"));
            shell.setDefaultHistoryFilePatter("%W/shell/%A" + dictionaryContent + "-shell.history");
            shell.run();
        }
        System.exit(0);
    }

    private class Prompt {
        private String prompt;
        private boolean isDynamic;
        private final Pattern pattern = Pattern.compile("\\$\\{(.+)\\}");

        Prompt(String prompt) {
            this.setPrompt(prompt);
        }

        final void setPrompt(String newPrompt) {
            this.prompt = newPrompt == null || newPrompt.isEmpty() ? ">>>" : newPrompt;
            this.isDynamic = this.pattern.matcher(this.prompt).find();
            JLineShell.this.reader.setPrompt(this.prompt);
        }

        void setDynamicPrompt(CommandSet cs) {
            StringBuilder newPrompt = new StringBuilder(this.prompt);
            Matcher matcher = this.pattern.matcher(newPrompt);
            while (matcher.find()) {
                Object result;
                String item = matcher.group(1);
                try {
                    result = cs.invoke(new TokenizedCommand("get " + item));
                }
                catch (CommandArgumentMatchException | CommandArgumentTypeException | CommandInvocationException x) {
                    result = null;
                }
                newPrompt.replace(matcher.start(), matcher.end(), result == null ? "" : result.toString());
                matcher.reset();
            }
            JLineShell.this.reader.setPrompt(newPrompt.toString());
        }

        public boolean isDynamic() {
            return this.isDynamic;
        }
    }

    public class BuiltIns {
        @Command(description="Exit from the shell", level=0, type=Command.CommandType.QUERY)
        public void exit() {
            JLineShell.this.exitRequested = true;
        }

        @Command(description="Show command history", level=0, type=Command.CommandType.QUERY)
        public void history() {
            History history = JLineShell.this.reader.getHistory();
            ListIterator entries = history.entries();
            while (entries.hasNext()) {
                History.Entry e = (History.Entry)entries.next();
                JLineShell.this.printWriter.printf("%3d: %s\n", e.index() + 1, e.value());
            }
        }

        @Command(description="Show the full stacktrace of the most recent error", alias="st", level=0, type=Command.CommandType.QUERY)
        public void stacktrace() {
            if (JLineShell.this.lastException != null) {
                JLineShell.this.lastException.printStackTrace(JLineShell.this.printWriter);
            }
        }

        @Command(description="Set shell properties", level=0, type=Command.CommandType.QUERY)
        public void set(@Argument(name="item") SetCommands what, @Argument(name="value", defaultValue="") String value) {
            switch (what) {
                case PROMPT: {
                    JLineShell.this.prompt.setPrompt(value);
                }
            }
        }
    }

    public static enum SetCommands {
        PROMPT;

    }
}

