/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.services.aggregator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;

public class BasicChannel
implements AgentChannel {
    private final String path;
    private final AgentInfo agent;
    protected Object value;
    protected HashMap<String, Object> data;

    public BasicChannel(String path, AgentInfo agent) {
        this.path = path;
        this.agent = agent;
    }

    public BasicChannel(String path, AgentInfo agent, Map<String, Object> attributes, Object value) {
        this(path, agent);
        int n;
        this.value = value;
        if (attributes != null && (n = attributes.size()) > 0) {
            this.data = new HashMap(n + n / 3 + 1, 0.85f);
            this.data.putAll(attributes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicChannel(BasicChannel other) {
        BasicChannel basicChannel = other;
        synchronized (basicChannel) {
            this.path = other.path;
            this.agent = other.agent;
            this.value = other.value;
            this.data = new HashMap<String, Object>(other.data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicChannel(AgentChannel other) {
        AgentChannel agentChannel = other;
        synchronized (agentChannel) {
            this.path = other.getPath();
            this.agent = other.getAgent();
            this.value = other.get();
            this.data = new HashMap();
            other.getAttributes().forEach(key -> this.data.put((String)key, other.get(key)));
        }
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getAgentName() {
        return this.agent.getName();
    }

    @Override
    public AgentInfo getAgent() {
        return this.agent;
    }

    @Override
    public String getLocalPath() {
        return this.path.substring(this.path.indexOf("/") + 1);
    }

    @Override
    public synchronized <T> T get(Object key) {
        Object out;
        if (key == null) {
            return this.get();
        }
        String sKey = key.toString();
        if ("value".equals(sKey)) {
            return this.get();
        }
        Object object = out = this.data == null ? null : this.data.get(sKey);
        if (out == null) {
            try {
                out = this.agent.getAgentProperty(sKey);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return (T)out;
    }

    @Override
    public synchronized <T> T get() {
        return (T)this.value;
    }

    @Override
    public synchronized List<String> getAttributes() {
        return this.data == null ? Collections.emptyList() : new ArrayList<String>(this.data.keySet());
    }

    @Override
    public synchronized boolean set(Object key, Object value) {
        if (key == null) {
            return this.set(value);
        }
        String sKey = key.toString();
        if ("value".equals(sKey)) {
            return this.set(value);
        }
        if (this.data == null) {
            if (value == null) {
                return false;
            }
            this.data = new HashMap(4);
            this.data.put(sKey, value);
            return true;
        }
        if (value == null) {
            Object oldValue = this.data.remove(sKey);
            if (this.data.isEmpty()) {
                this.data = null;
            }
            return oldValue != null;
        }
        Object oldValue = this.data.put(sKey, value);
        if (oldValue instanceof ConfigurationParameterInfo && !(value instanceof ConfigurationParameterInfo)) {
            this.data.put(sKey, oldValue);
            return false;
        }
        return !value.equals(oldValue);
    }

    @Override
    public synchronized boolean set(Object value) {
        boolean out;
        boolean bl = out = !Objects.equals(this.value, value);
        if (out) {
            this.value = value;
        }
        return out;
    }

    public String toString() {
        return this.path;
    }

    public boolean equals(Object obj) {
        return this.path.equals(obj) || obj instanceof AgentChannel && this.path.equals(((AgentChannel)obj).getPath());
    }

    public int hashCode() {
        return this.path.hashCode();
    }
}

