/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.common.ui.SystemStatusPanel;
import org.lsst.ccs.subsystem.common.ui.TextFieldX;
import org.lsst.ccs.subsystem.common.ui.UiConstants;
import org.lsst.ccs.subsystem.common.ui.UiUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.utility.constants.FanState;
import org.lsst.ccs.subsystem.utility.constants.HeaterState;
import org.lsst.ccs.subsystem.utility.constants.UtilTrunkFans;
import org.lsst.ccs.subsystem.utility.constants.UtilTrunkHeaters;
import org.lsst.ccs.subsystem.utility.constants.UtilTrunkValves;
import org.lsst.ccs.subsystem.utility.constants.ValveState;
import org.lsst.ccs.subsystem.utility.constants.VpcControlState;
import org.lsst.ccs.subsystem.utility.data.UtilTrunkState;

public class UtilTrunkControlPanel
extends JPanel
implements UiUtilities.ActionHandler,
CommandSender.ReplyHandler {
    private static final String CMND_GET_STATE = "getFullState";
    private static final String[] heaterNames = new String[2];
    private final CommandSender sender;
    private final UiUtilities uiUtils;
    private SystemStatusPanel statusPanel;
    private JPanel mpcPanel;
    private JPanel vpcPanel;
    private JPanel utPanel;
    private final JLabel[] fanState = new JLabel[3];
    private final ButtonGroup[] fanBG = new ButtonGroup[3];
    private final JRadioButton[] fanOffRB = new JRadioButton[3];
    private final JRadioButton[] fanSpeedRB = new JRadioButton[3];
    private final TextFieldX[] fanSpeedTF = new TextFieldX[3];
    private final JRadioButton[] fanTempRB = new JRadioButton[3];
    private final TextFieldX[] fanTempTF = new TextFieldX[3];
    private final JLabel[] heaterState = new JLabel[2];
    private final ButtonGroup[] heaterBG = new ButtonGroup[2];
    private final JRadioButton[] heaterOffRB = new JRadioButton[2];
    private final JRadioButton[] heaterOnRB = new JRadioButton[2];
    private final TextFieldX[] heaterValueTF = new TextFieldX[2];
    private final JLabel[] valveState = new JLabel[3];
    private final ButtonGroup[] valveBG = new ButtonGroup[3];
    private final JRadioButton[] valveShutRB = new JRadioButton[3];
    private final JRadioButton[] valveOpenRB = new JRadioButton[3];
    private final TextFieldX[] valvePosnTF = new TextFieldX[3];
    private JLabel vpcState;
    private ButtonGroup vpcBG;
    private JRadioButton vpcManualRB;
    private JRadioButton vpcTempRB;
    private static final long serialVersionUID = 1L;

    public UtilTrunkControlPanel(String subsys) {
        this.sender = new CommandSender(subsys, (CommandSender.ReplyHandler)this);
        this.uiUtils = new UiUtilities((UiUtilities.ActionHandler)this);
        this.initComponents();
        new DisablePanel().run();
    }

    public void initPanel() {
        this.sender.sendCommand(true, null, CMND_GET_STATE, new Object[0]);
    }

    public void onCommandReply(Object reply, String path, String command, Object[] args) {
        this.updatePanel((UtilTrunkState)reply);
    }

    public void onCommandReject(String path, String command, Object[] args) {
        if (!command.equals(CMND_GET_STATE)) {
            this.sender.sendCommand(true, null, CMND_GET_STATE, new Object[0]);
        }
    }

    public void updatePanel(UtilTrunkState rs) {
        SwingUtilities.invokeLater(new UpdateUtilState(rs));
    }

    public void disablePanel() {
        SwingUtilities.invokeLater(new DisablePanel());
    }

    private void initComponents() {
        ButtonGroup bg;
        this.vpcState = UiUtilities.newLabel((String)"XXX", (int)UiUtilities.maxEnumLabelWidth(VpcControlState.class));
        this.vpcManualRB = this.uiUtils.newRadioButton("Manual", "MF0");
        this.vpcTempRB = this.uiUtils.newRadioButton("Temp", "MT0");
        this.vpcBG = new ButtonGroup();
        this.vpcBG.add(this.vpcManualRB);
        this.vpcBG.add(this.vpcTempRB);
        for (int fanId = 0; fanId < 3; ++fanId) {
            this.fanState[fanId] = UiUtilities.newLabel((String)"XXX", (int)UiUtilities.maxEnumLabelWidth(FanState.class));
            this.fanOffRB[fanId] = this.uiUtils.newRadioButton("Off", "FF" + fanId);
            this.fanSpeedRB[fanId] = this.uiUtils.newRadioButton("Speed", "FS" + fanId);
            this.fanTempRB[fanId] = this.uiUtils.newRadioButton("Temp", "FT" + fanId);
            bg = this.fanBG[fanId] = new ButtonGroup();
            bg.add(this.fanOffRB[fanId]);
            bg.add(this.fanSpeedRB[fanId]);
            bg.add(this.fanTempRB[fanId]);
            this.fanSpeedTF[fanId] = this.uiUtils.newTextFieldX("0000.00", "S" + fanId, 2, true);
            this.fanTempTF[fanId] = this.uiUtils.newTextFieldX("0000.00", "T" + fanId, 2, true);
        }
        for (int htrId = 0; htrId < 2; ++htrId) {
            this.heaterState[htrId] = UiUtilities.newLabel((String)"XXX", (int)UiUtilities.maxEnumLabelWidth(HeaterState.class));
            this.heaterOffRB[htrId] = this.uiUtils.newRadioButton("Off", "HF" + htrId);
            this.heaterOnRB[htrId] = this.uiUtils.newRadioButton("On", "HT" + htrId);
            bg = this.heaterBG[htrId] = new ButtonGroup();
            bg.add(this.heaterOffRB[htrId]);
            bg.add(this.heaterOnRB[htrId]);
            this.heaterValueTF[htrId] = this.uiUtils.newTextFieldX("0000.00", "H" + htrId, 2, true);
        }
        for (int vlvId = 0; vlvId < 3; ++vlvId) {
            this.valveState[vlvId] = UiUtilities.newLabel((String)"XXX", (int)UiUtilities.maxEnumLabelWidth(ValveState.class));
            this.valveShutRB[vlvId] = this.uiUtils.newRadioButton("Shut", "VF" + vlvId);
            this.valveOpenRB[vlvId] = this.uiUtils.newRadioButton("Open", "VT" + vlvId);
            bg = this.valveBG[vlvId] = new ButtonGroup();
            bg.add(this.valveShutRB[vlvId]);
            bg.add(this.valveOpenRB[vlvId]);
            this.valvePosnTF[vlvId] = this.uiUtils.newTextFieldX("0000.00", "V" + vlvId, 2, true);
        }
        this.statusPanel = new SystemStatusPanel(this.sender, "MonitorControl", true);
        this.utPanel = UiUtilities.newBorderedPanel((String)"UT Cooling Control");
        GridBagConstraints gbu = new GridBagConstraints();
        gbu.anchor = 17;
        gbu.insets = new Insets(4, 4, 0, 4);
        gbu.gridx = 0;
        gbu.gridy = 0;
        this.addFanLine(0, this.utPanel, gbu);
        ++gbu.gridy;
        gbu.insets.top = 0;
        gbu.gridx = 0;
        gbu.insets.bottom = 4;
        this.addValveLine(0, this.utPanel, gbu);
        this.utPanel.setMinimumSize(this.utPanel.getPreferredSize());
        this.mpcPanel = UiUtilities.newBorderedPanel((String)"MPC Control");
        GridBagConstraints gbm = new GridBagConstraints();
        gbm.anchor = 17;
        gbm.insets = new Insets(4, 4, 0, 4);
        gbm.gridx = 0;
        gbm.gridy = 0;
        this.addFanLine(2, this.mpcPanel, gbm);
        ++gbm.gridy;
        gbm.insets.top = 0;
        gbm.gridx = 0;
        gbm.insets.bottom = 4;
        this.addValveLine(2, this.mpcPanel, gbm);
        this.mpcPanel.setMinimumSize(this.mpcPanel.getPreferredSize());
        this.vpcPanel = UiUtilities.newBorderedPanel((String)"VPC Control");
        GridBagConstraints gbv = new GridBagConstraints();
        gbv.anchor = 17;
        gbv.insets = new Insets(4, 4, 0, 4);
        gbv.gridx = 0;
        gbv.gridy = 0;
        this.addModeLine(this.vpcPanel, gbv);
        ++gbv.gridy;
        gbv.insets.top = 0;
        gbv.gridx = 0;
        this.addHeaterLine(0, this.vpcPanel, gbv);
        ++gbv.gridy;
        gbv.gridx = 0;
        this.addHeaterLine(1, this.vpcPanel, gbv);
        ++gbv.gridy;
        gbv.gridx = 0;
        this.addFanLine(1, this.vpcPanel, gbv);
        ++gbv.gridy;
        gbv.gridx = 0;
        gbv.insets.bottom = 4;
        this.addValveLine(1, this.vpcPanel, gbv);
        this.vpcPanel.setMinimumSize(this.vpcPanel.getPreferredSize());
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(6, 6, 6, 6);
        gbc.anchor = 11;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.statusPanel, gbc);
        ++gbc.gridy;
        this.add((Component)this.utPanel, gbc);
        ++gbc.gridy;
        this.add((Component)this.mpcPanel, gbc);
        ++gbc.gridy;
        this.add((Component)this.vpcPanel, gbc);
    }

    private void addFanLine(int fanId, JPanel panel, GridBagConstraints gbc) {
        panel.add((Component)UiUtilities.newLabel((String)"Fan:", (int)0), gbc);
        ++gbc.gridx;
        gbc.insets.left = 4;
        panel.add((Component)this.fanState[fanId], gbc);
        ++gbc.gridx;
        panel.add((Component)this.fanOffRB[fanId], gbc);
        ++gbc.gridx;
        panel.add((Component)this.fanSpeedRB[fanId], gbc);
        ++gbc.gridx;
        panel.add((Component)this.fanSpeedTF[fanId], gbc);
        ++gbc.gridx;
        gbc.insets.left = 0;
        panel.add((Component)UiUtilities.newLabel((String)"D/C", (int)0), gbc);
        gbc.insets.left = 4;
        ++gbc.gridx;
        if (UtilTrunkFans.hasTempState(fanId)) {
            panel.add((Component)this.fanTempRB[fanId], gbc);
            ++gbc.gridx;
            panel.add((Component)this.fanTempTF[fanId], gbc);
            ++gbc.gridx;
            gbc.insets.left = 0;
            panel.add((Component)UiUtilities.newLabel((String)"\u00b0C", (int)0), gbc);
            gbc.insets.left = 4;
            ++gbc.gridx;
        }
    }

    private void addModeLine(JPanel panel, GridBagConstraints gbc) {
        panel.add((Component)UiUtilities.newLabel((String)"Mode:", (int)0), gbc);
        ++gbc.gridx;
        gbc.insets.left = 4;
        panel.add((Component)this.vpcState, gbc);
        ++gbc.gridx;
        panel.add((Component)this.vpcManualRB, gbc);
        ++gbc.gridx;
        panel.add((Component)this.vpcTempRB, gbc);
        ++gbc.gridx;
    }

    private void addValveLine(int valveId, JPanel panel, GridBagConstraints gbc) {
        panel.add((Component)UiUtilities.newLabel((String)"Valve:", (int)0), gbc);
        ++gbc.gridx;
        gbc.insets.left = 4;
        panel.add((Component)this.valveState[valveId], gbc);
        ++gbc.gridx;
        panel.add((Component)this.valveShutRB[valveId], gbc);
        ++gbc.gridx;
        panel.add((Component)this.valveOpenRB[valveId], gbc);
        ++gbc.gridx;
        panel.add((Component)this.valvePosnTF[valveId], gbc);
        ++gbc.gridx;
        panel.add((Component)UiUtilities.newLabel((String)"%", (int)0), gbc);
        ++gbc.gridx;
    }

    private void addHeaterLine(int htrId, JPanel panel, GridBagConstraints gbc) {
        panel.add((Component)UiUtilities.newLabel((String)(heaterNames[htrId] + ":"), (int)0), gbc);
        ++gbc.gridx;
        gbc.insets.left = 4;
        panel.add((Component)this.heaterState[htrId], gbc);
        ++gbc.gridx;
        panel.add((Component)this.heaterOffRB[htrId], gbc);
        ++gbc.gridx;
        panel.add((Component)this.heaterOnRB[htrId], gbc);
        ++gbc.gridx;
        panel.add((Component)this.heaterValueTF[htrId], gbc);
        ++gbc.gridx;
        gbc.insets.left = 0;
        panel.add((Component)UiUtilities.newLabel((String)"\u00b0C", (int)0), gbc);
        gbc.insets.left = 4;
        ++gbc.gridx;
    }

    public void handleRadioButton(String name) {
        char type = name.charAt(0);
        char action = name.charAt(1);
        int id = Integer.valueOf(name.substring(2));
        switch (type) {
            case 'M': {
                VpcControlState mState = action == 'T' ? VpcControlState.TEMP : VpcControlState.MANUAL;
                this.sender.sendCommand(null, "setVpcState", new Object[]{mState});
                break;
            }
            case 'F': {
                FanState fState = action == 'T' ? FanState.TEMP : (action == 'S' ? FanState.SPEED : FanState.OFF);
                this.sender.sendCommand(null, "setFanState", new Object[]{UtilTrunkFans.getName(id), fState});
                break;
            }
            case 'V': {
                ValveState vState = action == 'T' ? ValveState.POSN : ValveState.SHUT;
                this.sender.sendCommand(null, "setValveState", new Object[]{UtilTrunkValves.getName(id), vState});
                break;
            }
            case 'H': {
                HeaterState hState = action == 'T' ? HeaterState.ON : HeaterState.OFF;
                this.sender.sendCommand(null, "setHeaterState", new Object[]{UtilTrunkHeaters.getName(id), hState});
            }
        }
    }

    public void handleTextFieldX(String name, Object value) {
        char type = name.charAt(0);
        int id = Integer.valueOf(name.substring(1));
        switch (type) {
            case 'S': {
                this.sender.sendCommand(null, "setFanSpeed", new Object[]{UtilTrunkFans.getName(id), (Double)value});
                break;
            }
            case 'T': {
                this.sender.sendCommand(null, "setFanDeltaTemp", new Object[]{UtilTrunkFans.getName(id), (Double)value});
                break;
            }
            case 'V': {
                this.sender.sendCommand(null, "setValvePosition", new Object[]{UtilTrunkValves.getName(id), (Double)value / 100.0});
                break;
            }
            case 'H': {
                this.sender.sendCommand(null, "setHeaterValue", new Object[]{UtilTrunkHeaters.getName(id), (Double)value});
            }
        }
    }

    static {
        UtilTrunkControlPanel.heaterNames[0] = "Heater1";
        UtilTrunkControlPanel.heaterNames[1] = "Heater2";
    }

    class DisablePanel
    implements Runnable {
        DisablePanel() {
        }

        @Override
        public void run() {
            UtilTrunkControlPanel.this.statusPanel.disablePanel();
            for (int fanId = 0; fanId < 3; ++fanId) {
                UtilTrunkControlPanel.this.fanState[fanId].setEnabled(false);
                UtilTrunkControlPanel.this.fanOffRB[fanId].setEnabled(false);
                UtilTrunkControlPanel.this.fanSpeedRB[fanId].setEnabled(false);
                UtilTrunkControlPanel.this.fanTempRB[fanId].setEnabled(false);
                UtilTrunkControlPanel.this.fanSpeedTF[fanId].setDisabled();
                UtilTrunkControlPanel.this.fanTempTF[fanId].setDisabled();
            }
            for (int htrId = 0; htrId < 2; ++htrId) {
                UtilTrunkControlPanel.this.heaterState[htrId].setEnabled(false);
                UtilTrunkControlPanel.this.heaterOffRB[htrId].setEnabled(false);
                UtilTrunkControlPanel.this.heaterOnRB[htrId].setEnabled(false);
                UtilTrunkControlPanel.this.heaterValueTF[htrId].setDisabled();
            }
            for (int vlvId = 0; vlvId < 3; ++vlvId) {
                UtilTrunkControlPanel.this.valveState[vlvId].setEnabled(false);
                UtilTrunkControlPanel.this.valveShutRB[vlvId].setEnabled(false);
                UtilTrunkControlPanel.this.valveOpenRB[vlvId].setEnabled(false);
                UtilTrunkControlPanel.this.valvePosnTF[vlvId].setDisabled();
            }
            UtilTrunkControlPanel.this.vpcState.setEnabled(false);
            UtilTrunkControlPanel.this.vpcManualRB.setEnabled(false);
            UtilTrunkControlPanel.this.vpcTempRB.setEnabled(false);
            UtilTrunkControlPanel.this.repaint();
        }
    }

    class UpdateUtilState
    implements Runnable {
        private final UtilTrunkState uts;

        UpdateUtilState(UtilTrunkState uts) {
            this.uts = uts;
        }

        @Override
        public void run() {
            JRadioButton selButton;
            JLabel label;
            Enum st;
            UtilTrunkControlPanel.this.statusPanel.updatePanel(this.uts.getTickMillis());
            for (int fanId = 0; fanId < 3; ++fanId) {
                st = this.uts.getFanState(fanId);
                st = st == null ? FanState.OFFLINE : st;
                label = UtilTrunkControlPanel.this.fanState[fanId];
                label.setText(st.toString());
                label.setForeground(st == FanState.TEMP ? UiConstants.GREEN : (st == FanState.SPEED ? UiConstants.YELLOW : (st == FanState.OFF ? Color.BLACK : UiConstants.BLUE)));
                st = this.uts.getFanBaseState(fanId);
                selButton = st == FanState.TEMP ? UtilTrunkControlPanel.this.fanTempRB[fanId] : (st == FanState.SPEED ? UtilTrunkControlPanel.this.fanSpeedRB[fanId] : UtilTrunkControlPanel.this.fanOffRB[fanId]);
                selButton.setSelected(true);
                UtilTrunkControlPanel.this.fanSpeedTF[fanId].update((Object)this.uts.getFanSpeed(fanId), true);
                UtilTrunkControlPanel.this.fanTempTF[fanId].update((Object)this.uts.getDeltaTemp(fanId), true);
                UtilTrunkControlPanel.this.fanState[fanId].setEnabled(true);
                UtilTrunkControlPanel.this.fanOffRB[fanId].setEnabled(true);
                UtilTrunkControlPanel.this.fanSpeedRB[fanId].setEnabled(true);
                UtilTrunkControlPanel.this.fanTempRB[fanId].setEnabled(true);
            }
            for (int htrId = 0; htrId < 2; ++htrId) {
                st = this.uts.getHeaterState(htrId);
                st = st == null ? HeaterState.OFFLINE : st;
                label = UtilTrunkControlPanel.this.heaterState[htrId];
                label.setText(st.toString());
                label.setForeground(st == HeaterState.TEMP ? UiConstants.GREEN : (st == HeaterState.ON ? UiConstants.YELLOW : (st == HeaterState.OFF ? Color.BLACK : UiConstants.BLUE)));
                st = this.uts.getHeaterBaseState(htrId);
                selButton = st == HeaterState.ON ? UtilTrunkControlPanel.this.heaterOnRB[htrId] : UtilTrunkControlPanel.this.heaterOffRB[htrId];
                selButton.setSelected(true);
                UtilTrunkControlPanel.this.heaterValueTF[htrId].update((Object)this.uts.getHeaterValue(htrId), true);
                UtilTrunkControlPanel.this.heaterState[htrId].setEnabled(true);
                UtilTrunkControlPanel.this.heaterOffRB[htrId].setEnabled(true);
                UtilTrunkControlPanel.this.heaterOnRB[htrId].setEnabled(true);
            }
            for (int vlvId = 0; vlvId < 3; ++vlvId) {
                st = this.uts.getValveState(vlvId);
                st = st == null ? ValveState.OFFLINE : st;
                label = UtilTrunkControlPanel.this.valveState[vlvId];
                label.setText(st.toString());
                label.setForeground(st == ValveState.TEMP ? UiConstants.GREEN : (st == ValveState.POSN ? UiConstants.YELLOW : (st == ValveState.SHUT ? Color.BLACK : UiConstants.BLUE)));
                st = this.uts.getValveBaseState(vlvId);
                selButton = st == ValveState.POSN ? UtilTrunkControlPanel.this.valveOpenRB[vlvId] : UtilTrunkControlPanel.this.valveShutRB[vlvId];
                selButton.setSelected(true);
                UtilTrunkControlPanel.this.valvePosnTF[vlvId].update((Object)(100.0 * this.uts.getValvePosition(vlvId)), true);
                UtilTrunkControlPanel.this.valveState[vlvId].setEnabled(true);
                UtilTrunkControlPanel.this.valveShutRB[vlvId].setEnabled(true);
                UtilTrunkControlPanel.this.valveOpenRB[vlvId].setEnabled(true);
            }
            VpcControlState vst = this.uts.getVpcState();
            vst = vst == null ? VpcControlState.MANUAL : vst;
            JLabel label2 = UtilTrunkControlPanel.this.vpcState;
            label2.setText(vst.toString());
            label2.setForeground(vst == VpcControlState.TEMP ? UiConstants.GREEN : Color.BLACK);
            JRadioButton selButton2 = vst == VpcControlState.TEMP ? UtilTrunkControlPanel.this.vpcTempRB : UtilTrunkControlPanel.this.vpcManualRB;
            selButton2.setSelected(true);
            UtilTrunkControlPanel.this.vpcState.setEnabled(true);
            UtilTrunkControlPanel.this.vpcManualRB.setEnabled(true);
            UtilTrunkControlPanel.this.vpcTempRB.setEnabled(true);
            UtilTrunkControlPanel.this.repaint();
        }
    }
}

