/*
 * Decompiled with CFR 0.152.
 */
package jas.plot;

import jas.plot.AxisType;
import jas.plot.CoordinateTransformation;
import jas.plot.PlotGraphics;
import jas.plot.StringCoordinateTransformation;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.HashMap;

public final class StringAxisY
extends AxisType
implements StringCoordinateTransformation {
    private int labelPlacementStyle;
    private HashMap<String, Integer> hash;
    private final int majorTickLength = 5;
    private String[] labels;
    private Color[] colors;
    private double[] values;
    private double min;
    private double max;

    public StringAxisY() {
        this(1);
    }

    public StringAxisY(int labelPlacementStyle) {
        this.labelPlacementStyle = labelPlacementStyle;
    }

    public void setLabelPlacementStyle(int labelPlacementStyle) {
        this.labelPlacementStyle = labelPlacementStyle;
    }

    public int getLabelPlacementStyle() {
        return this.labelPlacementStyle;
    }

    public void setLabels(String[] labels, double[] values, Color[] colors, double min, double max) {
        this.colors = colors;
        this.values = values;
        this.min = min;
        this.max = max;
        this.setLabels(labels);
    }

    public void setLabels(String[] labels, double base, double step, Color color, double min, double max) {
        int n = labels.length;
        this.colors = new Color[n];
        Arrays.fill(this.colors, color);
        this.values = new double[n];
        for (int i = 0; i < n; ++i) {
            this.values[i] = base + (double)i * step;
        }
        this.min = min;
        this.max = max;
        this.setLabels(labels);
    }

    private void setLabels(String[] labels) {
        if (this.hash == null) {
            this.hash = new HashMap();
        } else {
            this.hash.clear();
        }
        this.labels = labels;
        for (int i = 0; i < labels.length; ++i) {
            this.hash.put(labels[i], i);
        }
        this.labelsValid = false;
    }

    @Override
    void paintAxis(PlotGraphics g, double originX, double originY, double length, Color textColor, Color majorTickColor, Color minorTickColor) {
        if (this.labels != null) {
            FontMetrics fm = g.getFontMetrics();
            double x = this.axis.onLeftSide ? originX - 7.0 : originX + 7.0;
            double scale = length / (this.max - this.min);
            double height = fm.getAscent() / 2;
            for (int i = 0; i < this.labels.length; ++i) {
                double y = originY - length + scale * (this.max - this.values[i]);
                g.setColor(this.colors[i]);
                g.drawString(this.labels[i], this.axis.onLeftSide ? x - (double)fm.stringWidth(this.labels[i]) : x, y + height);
            }
        }
    }

    @Override
    CoordinateTransformation getCoordinateTransformation() {
        return this;
    }

    @Override
    void assumeAxisLength(int lengthOfAxisLine) {
        if (this.labels == null || this.labels.length == 0) {
            return;
        }
        this.labelsValid = true;
        Font font = this.axis.getFont();
        FontMetrics fm = this.axis.getToolkit().getFontMetrics(font);
        int distanceFromEnd = this.labelPlacementStyle == 1 ? lengthOfAxisLine / this.labels.length / 2 : 0;
        this.spaceRequirements.width = this.longestStringLength(fm, this.labels) + 7;
        this.spaceRequirements.height = Math.max(0, fm.getAscent() / 2 + fm.getMaxDescent() - distanceFromEnd);
        this.spaceRequirements.flowPastEnd = this.labelPlacementStyle == 1 ? Math.max(fm.getMaxAscent() - fm.getAscent() / 2 - lengthOfAxisLine / this.labels.length / 2, 0) : fm.getMaxAscent() - fm.getAscent() / 2;
    }

    @Override
    int getMajorTickMarkLength() {
        return 5;
    }

    @Override
    public double convert(String s) {
        try {
            return this.indexToLocation(this.hash.get(s));
        }
        catch (Exception e) {
            return -1.0;
        }
    }

    @Override
    public double binWidth() {
        return (double)(this.axis.getMaxLocation() - this.axis.getMinLocation()) / (double)this.labels.length;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.labelPlacementStyle);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.labelPlacementStyle = in.readInt();
    }

    private int longestStringLength(FontMetrics fm, String[] labels) {
        int longestLength = 0;
        for (int i = 0; i < labels.length; ++i) {
            int length = fm.stringWidth(labels[i]);
            if (length <= longestLength) continue;
            longestLength = length;
        }
        return longestLength;
    }

    private double indexToLocation(int index) {
        double minL = this.axis.getMinLocation();
        double maxL = this.axis.getMaxLocation();
        if (this.labelPlacementStyle == 1) {
            return minL + (maxL - minL) * (double)index / (double)this.labels.length + (maxL - minL) / (double)this.labels.length / 2.0;
        }
        return minL + (maxL - minL) * (double)index / (double)this.labels.length;
    }
}

