/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.auxelex;

import org.lsst.ccs.drivers.auxelex.Srp;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;

public class SrpException
extends DriverException {
    private static final int SRP_STS_TIMEOUT = 2;
    private static final int SRP_STS_ERROR = 1;
    private static final int SRP3_STS_MEMORY = 255;
    private static final int SRP3_STS_TIMEOUT = 256;
    private static final int SRP3_STS_EOFE = 512;
    private static final int SRP3_STS_FRAMING = 1024;
    private static final int SRP3_STS_VERSION = 2048;
    private static final int SRP3_STS_REQUEST = 4096;
    private static final long serialVersionUID = 2455904340900648746L;
    private final int status;
    private String extraMessage;

    SrpException(String logName, String message, int status) {
        super(Srp.formatLogName(logName) + message + " (status=" + Integer.toHexString(status) + ")");
        this.status = status;
    }

    SrpException(String logName, String message) {
        super(Srp.formatLogName(logName) + message);
        this.status = 0;
    }

    SrpException(String logName, String message, Throwable cause) {
        super(logName == null ? "" : logName + ": " + message, cause);
        this.status = 0;
    }

    public String getMessage() {
        String message = super.getMessage();
        if (this.extraMessage != null) {
            return message + " (" + this.extraMessage + ")";
        }
        return message;
    }

    public int getStatus() {
        return this.status;
    }

    void addDetails(String extraMessage) {
        this.extraMessage = extraMessage;
    }

    static SrpException create3(String logName, int status) {
        if ((status & 0xFF) != 0) {
            return new SrpInvalidRegisterAddressException(logName, status);
        }
        if ((status & 0x100) != 0) {
            return new SrpRegisterAccessTimeoutException(logName, status);
        }
        if ((status & 0x200) != 0) {
            return new SrpEndOfFrameException(logName, status);
        }
        if ((status & 0x400) != 0) {
            return new SrpFramingException(logName, status);
        }
        if ((status & 0x800) != 0) {
            return new SrpVersionMismatchException(logName, status);
        }
        if ((status & 0x1000) != 0) {
            return new SrpInvalidRequestException(logName, status);
        }
        return new SrpException(logName, "Unknown error", status);
    }

    static SrpException create0(String logName, int status) {
        if ((status & 2) != 0) {
            return new SrpRegisterAccessTimeoutException(logName, status);
        }
        return new SrpException(logName, "Unknown error", status);
    }

    public static class SrpInvalidRequestException
    extends SrpException {
        private static final long serialVersionUID = -8437270228409744211L;

        SrpInvalidRequestException(String logName, int status) {
            super(logName, "Invalid request", status);
        }
    }

    public static class SrpVersionMismatchException
    extends SrpException {
        private static final long serialVersionUID = 5306785243067574205L;

        SrpVersionMismatchException(String logName, int status) {
            super(logName, "Version mismatch", status);
        }
    }

    public static class SrpFramingException
    extends SrpException {
        private static final long serialVersionUID = 6991600583438830264L;

        SrpFramingException(String logName, int status) {
            super(logName, "Framing error", status);
        }
    }

    public static class SrpEndOfFrameException
    extends SrpException {
        private static final long serialVersionUID = 608402485101612599L;

        SrpEndOfFrameException(String logName, int status) {
            super(logName, "End of frame with error", status);
        }
    }

    public static class SrpRegisterAccessTimeoutException
    extends SrpException {
        private static final long serialVersionUID = -7542864357902100945L;

        SrpRegisterAccessTimeoutException(String logName, int status) {
            super(logName, "Register access timeout (FATAL???!!!)", status);
        }
    }

    public static class SrpInvalidRegisterAddressException
    extends SrpException {
        private static final long serialVersionUID = 9025518445392473744L;

        SrpInvalidRegisterAddressException(String logName, int status) {
            super(logName, "Invalid Register Address", status);
        }
    }

    public static class SrpTimeoutException
    extends DriverTimeoutException {
        private static final long serialVersionUID = -2082721527482465140L;

        SrpTimeoutException(String logName, String message, Throwable cause) {
            super(Srp.formatLogName(logName) + message, cause);
        }
    }
}

